<?php

namespace App\Helpers;

use App\Models\Cart;
use App\Models\DiscountProduct;
use App\Models\ProductImage;
use App\Models\Setting;
use Illuminate\Support\Facades\Session;

class Carts
{
    // Website information
    public static function list()
    {
        $carts = Cart::with(['product', 'product_combination'])->where('user_id', auth()->id())
            ->orderBy('created_at', 'desc')
            ->get();
        if (Session::has('coupon') && !empty(Session::get('coupon'))) {
            $coupon = Session::get('coupon');
        }

        $datas = [];
        $total_price = 0;
        $responce['delivery_charge'] = number_format(0, 2, '.', '');
        if (!empty($carts)) {
            foreach ($carts as $key => $cart) {
                //                $main_price = $cart->product_combination->main_price - $cart->product_combination->discount_price;

                $product_type_id = $cart->product_combination->product_type_id ?? null;
                $tag_id = $cart->product_combination->tag_id ?? null;
                $product_combination_id = $cart->product_combination->id ?? null;
                $colorMaster_id = $cart->product->colorMaster_id ?? null;

                $discount = DiscountProduct::where(
                    'product_id',
                    $cart->product->id,
                )
                    ->where('color_id', $cart->product->color_id)
                    ->where('category', $cart->product->category)
                    ->where('product_type_id', $product_type_id)
                    ->where(
                        'tag_id',
                        $tag_id
                    )->where(
                        'product_combination_id',
                        $product_combination_id,
                    )
                    ->where('color_master_id', $colorMaster_id)
                    ->first();

                $discount_price = $cart->product_combination->discount_price ?? 0;
                if (!empty($discount) || isset($discount)) {
                    if ($discount->discount == 1) {
                        if ($discount->type == 2) {
                            $total_price_dis =
                                $discount_price +
                                $discount->dis_amount;
                            $main_price = $total_price_dis;
                        } else {
                            $discuntPercentage =
                                ($discount->dis_amount / 100) *
                                $discount_price;
                            $total_price_dis =
                                $discount_price +
                                $discuntPercentage;
                            $main_price = $total_price_dis;
                        }
                    } else {
                        if ($discount->type == 2) {
                            $total_price_dis =
                                $discount_price -
                                $discount->dis_amount;
                            $main_price = $total_price_dis;
                        } else {
                            $discuntPercentage =
                                ($discount->dis_amount / 100) *
                                $discount_price;
                            $total_price_dis =
                                $discount_price -
                                $discuntPercentage;
                            $main_price = $total_price_dis;
                        }
                    }
                } else {
                    $main_price =
                        $discount_price;
                }


                // if (isset($cart->product_combination->discount_price) && !empty($cart->product_combination->discount_price)) {
                //     $main_price = $cart->product_combination->discount_price;
                // } else {
                //     $main_price = $cart->product_combination->main_price;
                // }
                $payable_price = $main_price * $cart->quantity;

                $product_image = ProductImage::where('product_id', $cart->product_id)->first();

                $data['cart_id'] = $cart->id;
                $data['product_id'] = $cart->product_id;
                $data['name'] = $cart->product_combination->name ?? null;
                $data['product_name'] = $cart->product->name ?? null;
                $data['quantity'] = $cart->quantity;
                if ($cart->product->category == 1) {
                    $data['image'] = asset($cart->product_combination->productType->image ?? null);
                } else {
                    $data['image'] = asset($product_image->image ?? null);
                }
                $data['color'] = $cart->color->name ?? null;
                $data['tag'] = $cart->product_combination->tag->name ?? null;
                $data['length'] = $cart->product_combination->length->name ?? null;
                $data['type'] = $cart->product->type->name ?? null;
                $data['price'] = $cart->product_combination->main_price ?? 0;
                $data['dimension'] = $cart->product_combination->dimension ?? null;
                $data['discount_price'] = $cart->product_combination->discount_price ?? 0;
                $data['main_price'] = number_format($main_price, 2, '.', '');
                $data['payable_price'] = number_format($payable_price, 2, '.', '');
                $datas[] = $data;
                $total_price = $total_price + $payable_price;
            }
        }
        $responce['subtotal'] = number_format($total_price, 2, '.', '');
        $delivery_charge = Setting::first();
        if (!empty($delivery_charge) && !empty($delivery_charge['delivery_charge'])) {
            $responce['delivery_charge'] = number_format($delivery_charge['delivery_charge'], 2, '.', '');
            $total_price = $total_price + $delivery_charge['delivery_charge'];
        }
        // dd(isset($coupon->type));

        if (!empty($coupon->discount) && isset($coupon->type)) {
            $responce['coupon_id'] = $coupon->id;
            if ($coupon->type == 0) {
                $responce['coupon_type'] = 'Amount';
                $responce['coupon_discount'] = number_format($coupon->discount, 2, '.', '');
                $total_price = $total_price - $coupon->discount;
                $responce['coupon_discount_amount'] = number_format($coupon->discount, 2, '.', '');
            } else {
                $responce['coupon_type'] = 'Percentage';
                $responce['coupon_discount'] = number_format($coupon->discount, 2, '.', '');
                $discuntPercentage = ($coupon->discount / 100) * $total_price;
                $responce['coupon_discount_amount'] = number_format($discuntPercentage, 2, '.', '');
                $total_price = $total_price - $discuntPercentage;
            }
        }
        $responce['carts'] = $datas;
        $responce['cart_count'] = count($carts);
        $responce['total_price'] = number_format($total_price, 2, '.', '');

        return $responce;
    }
}
