<?php

namespace App\Helpers;

use App\Models\{Brand, BrandTitle, Cart, Color, ColorMaster, OurServises, OurServisesMaster, Product, ProductCombination, ProductImage, Setting, Type, PropertyOwner, TitleHome, YoutubeLink};
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class SiteInfo
{
    // Website information
    public static function info()
    {
        $setting = Setting::first();
        $data['site_name'] = $setting['site_name'];
        $data['site_logo'] = $setting['site_logo'];
        $data['site_fav_icon'] = $setting['site_fav_icon'];
        $data['copyright'] = $setting['copyright'];
        $data['footer_text'] = $setting['footer_text'];
        $data['time'] = $setting['time'];
        $data['facebook'] = $setting['facebook'];
        $data['twitter'] = $setting['twitter'];
        $data['linkedin'] = $setting['linkedin'];
        $data['instagram'] = $setting['instagram'];
        $data['email'] = $setting['email'];
        $data['phone_call'] = $setting['phone_call'];
        $data['address'] = $setting['address'];
        $data['address1'] = $setting['address1'];
        $data['phone_whatsapp'] = $setting['phone_whatsapp'];
        $data['map'] = $setting['map'];
        $data['map1'] = $setting['map1'];
        $data['descraption'] = $setting['descraption'];
        $data['google_plus_alpharetta'] = $setting['google_plus_alpharetta'];
        $data['google_plus_norcross'] = $setting['google_plus_norcross'];
        $data['google_review_alpharetta'] = $setting['google_review_alpharetta'];
        $data['google_review_norcross'] = $setting['google_review_norcross'];
        return $data;
    }
    // Proparty types
    public static function types()
    {
        $types = Type::where('status', 1)->where('id', '!=', 1)->select('id', 'name')->get();
        return $types;
    }
    public static function cartCount()
    {
        $carts = Cart::where('user_id', Auth::id())->count();
        return $carts;
    }  // Proparty types
    public static function color($id)
    {
        $colorMaster = ColorMaster::where('id', $id)->first();
        $productHaveColorMaster = Product::where('category', $colorMaster->category_id)
            ->pluck('color_id')
            ->toArray();
        $color = Color::whereIn('id', explode(',', $colorMaster->color_id))
            ->whereIn('id', array_unique($productHaveColorMaster))
            ->get();
        return $color;
    }
    public static function productCombination($id, $filter_tag_id, $product_id)
    {
        $productCombination = ProductCombination::where('product_type_id', $id);
        if (!empty($filter_tag_id)) {
            $productCombination->where('tag_id', $filter_tag_id);
        }
        $productCombination = $productCombination->where(['status' => 1, 'product_id' => $product_id, 'in_stock' => 1])
            ->get();
        return $productCombination;
    }
    // Youtube Link
    public static function youtube()
    {
        $link = YoutubeLink::where('status', 1)->first();
        $YoutubeLink = explode("=", $link->youtube_link);
        return $YoutubeLink;
    }
    public static function title()
    {
        $title = TitleHome::first();
        return $title;
    }
    public static function cabinet_image($id)
    {
        $image = ProductImage::where('product_id', $id)->first();
        return $image;
    }
    public static function brands()
    {
        $brands = Brand::where('status', 1)->orderBy('sort_order', 'asc')->get();
        return $brands;
    }
    public static function ourServices()
    {
        $ourServices = OurServisesMaster::where('status', 1)->get();
        return $ourServices;
    }
    public static function categories()
    {
        $categories = Type::where('status', 1)->orderBy('id', 'asc')->get();
        return $categories;
    }
    public static function brandsTitle()
    {
        $brandsTitle = BrandTitle::first();
        return $brandsTitle;
    }
    // Format Date type 1
    public static function dateFormatOne($date)
    {
        $formated_date = Carbon::parse($date)->format('d M, Y');
        return $formated_date;
    }
}
