<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserAddress;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => ['required', 'min:8', 'max:8'],
            'password' => ['required', 'min:8']
        ], [
            'mobile.required' => __('Mobile number is required'),
            'mobile.min' => __('Mobile number is required'),
            'mobile.max' => __('Mobile number is required'),
            'password.required' => __('Password is required'),
            'password.min' => __('Password is required')
        ]);

        if ($validator->fails()) {
            foreach ($validator->errors()->toArray() as $error) {
                return response()->json(['status' => 'error', 'message' => $error[0]]);
            }
        }

        $credentials = [
            'type' => 4,
            'mobile' => $request->mobile,
            'password' => $request->password,
            'status' => 1
        ];

        if (!auth()->attempt($credentials)) {
            return response()->json(['status' => 'error', 'message' => __('Invalid Credentials')]);
        }

        $userAddress = UserAddress::where('user_id', auth()->user()->id)->first();
        if (!$userAddress) {
            $userAddress = new UserAddress();
            $userAddress->user_id = auth()->user()->id;
            $userAddress->governorate_id = null;
            $userAddress->area_id = null;
            $userAddress->block = null;
            $userAddress->street = null;
            $userAddress->house_number = null;
            $userAddress->apartment = null;
            $userAddress->floor = null;
            $userAddress->other = null;
            $userAddress->status = 1;
            $userAddress->save();
        }

        $accessToken = auth()->user()->createToken('authToken')->plainTextToken;

        $user = User::where('id', Auth::user()->id)->with('userAddress')->first();

        return response()->json([
            'status' => 'ok',
            'message' => __('Logged in successfully'),
            'user' => $user,
            'access_token' => $accessToken
        ]);
    }
}
