<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserAddress;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RegistrationController extends Controller
{
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'mobile' => 'required|numeric|min:12',
            'password' => 'required|min:6'
        ], [
            'name.required' => __('please_enter_name'),
            'email.required' => __('email'),
            'mobile.required' => __('number_required'),
            'mobile.numeric' => __('number_required'),
            'mobile.min' => __('number_required'),
            'password.required' => __('password_required'),
            'password.min' => __('password_min')
        ]);

        if ($validator->fails()) {
            foreach ($validator->errors()->toArray() as $error) {
                return response()->json(['status' => 'error', 'message' => $error[0]]);
            }
        }

        $is_mobile_exist = User::where('type', 4)->where(['mobile' => $request->mobile])->count();
        if ($is_mobile_exist > 0) {
            return response()->json(array('status' => 'error', 'message' => __('User already registered')));
        }

        $user = new User();
        $user->type = 4;
        $user->first_name = $request->name;
        $user->email = $request->email;
        $user->mobile = $request->mobile;
        $user->password = $request->password;
        $user->status = 1;
        $user->save();

        $userAddress = new UserAddress();
        $userAddress->user_id = $user->id;
        $userAddress->governorate_id = null;
        $userAddress->area_id = null;
        $userAddress->block = null;
        $userAddress->street = null;
        $userAddress->house_number = null;
        $userAddress->apartment = null;
        $userAddress->floor = null;
        $userAddress->other = null;
        $userAddress->status = 1;
        $userAddress->save();

        $credentials = [
            'mobile' => $request->mobile,
            'password' => $request->password,
        ];

        if (!auth()->attempt($credentials)) {
            return response()->json(['status' => 'error', 'message' => __('Invalid Credentials')]);
        }

        $accessToken = auth()->user()->createToken('authToken')->plainTextToken;

        $user = User::where('id', Auth::user()->id)->with('userAddress')->first();

        return response()->json([
            'status' => 'ok',
            'message' => __('Registration successful'),
            'user' => $user,
            'access_token' => $accessToken
        ]);
    }
}
