<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\BrandTitle;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;

class BrandsTitleController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brandTitle = BrandTitle::first();
        if (!empty($brandTitle)) {
            return view('backend.master.brandTitle.update', compact('brandTitle'));
        } else {
            return view('backend.master.brandTitle.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.brandTitle.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',
            'title' => 'required',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'brandTitle';
                $one['save_path'] = 'brandTitle';
                $image = $this->save($one);
            }

            $create = new BrandTitle();
            $create->title = $request->title;
            $create->image = $image;
            $create->save();

            return redirect()->route('backend.brandsTitle.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brandTitle = brandTitle::where('id', $id)->first();
        return view('backend.master.brandTitle.update', compact('brandTitle'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max size must have 1024.'
        ];

        $request->validate([
            'title' => 'required',
        ]);
        try {
            $brandTitle = brandTitle::where('id', $id)->first();

            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'brandTitle';
                $data['save_path'] = '/brandTitle';
                $data['old_image']=$brandTitle->image;
                $image = $this->save($data);
                $brandTitle->image = $image;
            }
            $brandTitle->title = $request->title;
            $brandTitle->save();

            return redirect()->route('backend.brandTitle.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
