<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Coupon;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class CouponController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Coupon::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['name'] = $item->name ?? '-';
                    $nestedData['code'] = $item->code ?? '-';
                    if ($item->type == 1) {
                        $nestedData['type'] = 'Percentage';
                    } else {
                        $nestedData['type'] = 'Amount';
                    }
                    $nestedData['discount'] = $item->discount ?? '-';
                    $nestedData['date'] = Carbon::parse($item->start_date)->format('Y/m/d') . '-' . Carbon::parse($item->end_date)->format('Y/m/d');
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.coupon.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }

        return view('backend.coupon.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.coupon.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'code' => 'required',
            'minemum_blance' => 'required',
            'user_limit' => 'required',
            'type' => 'required',
            'discount' => 'required',
            'date' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $date = explode(" - ", $request->date);
            $create = new Coupon();
            $create->name = $request->name;
            $create->code = $request->code;
            $create->minemum_blance = $request->minemum_blance;
            $create->user_limit = $request->user_limit;
            $create->type = $request->type;
            $create->discount = $request->discount;
            $create->start_date = Carbon::parse($date[0])->format('Y-m-d');
            $create->end_date = Carbon::parse($date[1])->format('Y-m-d');
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.coupon.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $coupon = Coupon::where('id', $id)->first();
        return view('backend.coupon.update', compact('coupon'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'code' => 'required',
            'minemum_blance' => 'required',
            'user_limit' => 'required',
            'type' => 'required',
            'discount' => 'required',
            'date' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $date = explode(" - ", $request->date);
            $create = Coupon::where('id', $id)->first();
            $create->name = $request->name;
            $create->code = $request->code;
            $create->minemum_blance = $request->minemum_blance;
            $create->user_limit = $request->user_limit;
            $create->type = $request->type;
            $create->discount = $request->discount;
            $create->start_date = Carbon::parse($date[0])->format('Y-m-d');
            $create->end_date = Carbon::parse($date[1])->format('Y-m-d');
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.coupon.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Coupon::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
