<?php

namespace App\Http\Controllers\Backend;

use Exception;
use App\Models\{User, CustomerReview};
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\ImageUploadTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\View;

class CustomerController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = CustomerReview::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    if (!empty($item->image)) {

                        $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    } else {

                        $nestedData['image'] = '-';
                    }
                    $nestedData['name'] = $item->name ?? '-';
                    // $nestedData['position'] = $item->position ?? '-';
                    $nestedData['commend'] = $item->commend ?? '-';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.customerReview.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.customerReview.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.customer.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:customer_reviews,name',
            'retting' => 'required',
            'commend' => 'required',
            'status' => 'required|numeric',

        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'customer';
                $one['save_path'] = 'customer';
                $image = $this->save($one);
            }

            $create = new CustomerReview();
            $create->name = $request->name;
            $create->retting = $request->retting ?? null;
            $create->verified = $request->verified ?? 2;
            $create->image = $image ?? null;
            $create->commend = $request->commend;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.customerReview.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\User $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\User $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $customer = CustomerReview::where('id', $id)->first();
        return view('backend.customer.update', compact('customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Models\User $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'retting' => 'required',
            'commend' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $customer = CustomerReview::where('id', $id)->first();

            if (isset($request->image) && !empty($request->image)) {

                $data['image'] = $request->image;
                $data['path'] = 'customer';
                $data['save_path'] = '/customer';
                $data['old_image']=$customer->image;
                $image = $this->save($data);
                $customer->image = $image;
            }

            $customer->name = $request->name;
            $customer->retting = $request->retting ?? null;
            $customer->verified = $request->verified ?? 2;
            $customer->commend = $request->commend;
            $customer->status = $request->status;
            $customer->save();

            return redirect()->route('backend.customerReview.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\User $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        CustomerReview::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
