<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\FreeDesignRequest;
use App\Models\KitchenDesignRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class DesignRequestController extends Controller
{
    public function kitchen_design_request(Request $request)
    { {
            if ($request->ajax()) {
                $limit = $request->length;
                $start = $request->start;
                $query = KitchenDesignRequest::orderBy('id', 'desc');
                $totalFiltered = $query->count();
                $items = $query->offset($start)->limit($limit)->get();
                $data = [];
                if (count($items) > 0) {
                    foreach ($items as $key => $item) {
                        $nestedData['email'] = $item->email ?? '-';
                        $nestedData['action'] = (string)View::make('backend.kitchenDesigneRequest.action', ['item' => $item])->render();
                        $data[$key] = $nestedData;
                    }
                }

                $json_data = [
                    'draw' => $request->query('draw'),
                    'recordsTotal' => count($data),
                    'recordsFiltered' => $totalFiltered,
                    'data' => $data
                ];
                return response()->json($json_data);
            }
            return view('backend.kitchenDesigneRequest.index');
        }
    }
    public function free_design_request(Request $request)
    { {
            if ($request->ajax()) {
                $limit = $request->length;
                $start = $request->start;
                $query = FreeDesignRequest::orderBy('id', 'desc');
                $totalFiltered = $query->count();
                $items = $query->offset($start)->limit($limit)->get();
                $data = [];
                if (count($items) > 0) {
                    foreach ($items as $key => $item) {
                        $nestedData['name'] = $item->name ?? '-';
                        $nestedData['email'] = $item->email ?? '-';
                        $nestedData['action'] = (string)View::make('backend.freeDesigneRequest.action', ['item' => $item])->render();
                        $data[$key] = $nestedData;
                    }
                }

                $json_data = [
                    'draw' => $request->query('draw'),
                    'recordsTotal' => count($data),
                    'recordsFiltered' => $totalFiltered,
                    'data' => $data
                ];
                return response()->json($json_data);
            }
            return view('backend.freeDesigneRequest.index');
        }
    }
    public function kitchen_design_request_delete($id)
    {
        KitchenDesignRequest::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
    public function free_design_request_delete($id)
    {
        FreeDesignRequest::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
