<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Color;
use App\Models\ColorMaster;
use App\Models\DiscountProduct;
use App\Models\Product;
use App\Models\ProductCombination;
use App\Models\ProductType;
use App\Models\Tag;
use App\Models\Type;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class DiscountProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = DiscountProduct::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();
            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $category = Type::where('id', $item->category)->first();
                    $master = ColorMaster::where('id', $item->color_master_id)->first();
                    $productType = ProductType::where('id', $item->product_type_id)->first();
                    $color = Color::where('id', $item->color_id)->first();
                    $tag = Tag::where('id', $item->tag_id)->first();
                    $ProductCombination_name = ProductCombination::where('id', $item->product_combination_id)->first();

                    // dd($item->product_type_id);
                    $nestedData['category_id'] = $category->name ?? '-';
                    $nestedData['masterColor_id'] = $master->name ?? '-';
                    $nestedData['color_id'] = $color->name ?? '-';
                    $nestedData['product_type_id'] = $productType->name ?? '-';
                    $nestedData['tag_id'] = $tag->name ?? '-';
                    $nestedData['product_combination_id'] = $ProductCombination_name->name ?? '-';
                    $nestedData['dis_amount'] = $item->dis_amount ?? '-';
                    if ($item->discount == 1) {
                        $nestedData['discount'] = 'Increase';
                    } else {
                        $nestedData['discount'] = 'Decrease';
                    }
                    if ($item->type == 1) {
                        $nestedData['type'] = 'Percentage';
                    } else {
                        $nestedData['type'] = 'Amount';
                    }
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.discountProduct.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.discountProduct.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Type::where('status', 1)->get();
        $colors = Color::where('status', 1)->get();
        $tags = Tag::where('status', 1)->get();
        $productCombinations = ProductCombination::where('status', 1)->get();
        $productTypes = ProductType::where('status', 1)->get();
        return view('backend.master.discountProduct.create', compact('categories', 'colors', 'tags', 'productTypes', 'productCombinations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'category' => 'required',
            'color_id' => 'required',
            'masterColor_id' => 'required',
            'tag_id' => 'required',
            'product_type_id' => 'required',
            'discount' => 'required',
            'type' => 'required',
            'dis_amount' => 'required',
            'product_combination_id' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $products = Product::where('category', $request->category)->where('color_id', $request->color_id)->where('colorMaster_id', $request->masterColor_id)->first();

            $create = new DiscountProduct();
            $create->category = $request->category;
            $create->color_id = $request->color_id;
            $create->color_master_id = $request->masterColor_id;
            $create->product_id = $products->id;
            $create->tag_id = $request->tag_id;
            $create->product_type_id = $request->product_type_id;
            $create->discount = $request->discount;
            $create->type = $request->type;
            $create->dis_amount = $request->dis_amount;
            $create->product_combination_id = $request->product_combination_id;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.discountProduct.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $discountProduct = DiscountProduct::where('id', $id)->first();
        $category_name = Type::where('id', $discountProduct->category)->first();
        $master_name = ColorMaster::where('id', $discountProduct->color_master_id)->first();
        $productType_name = ProductType::where('id', $discountProduct->product_type_id)->first();
        $color_name = Color::where('id', $discountProduct->color_id)->first();
        $tag_name = Tag::where('id', $discountProduct->tag_id)->first();
        $ProductCombination_name = ProductCombination::where('id', $discountProduct->product_combination_id)->first();
        return view('backend.master.discountProduct.update', compact('category_name', 'ProductCombination_name', 'master_name', 'productType_name', 'color_name', 'tag_name', 'discountProduct'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'discount' => 'required',
            'type' => 'required',
            'dis_amount' => 'required',
            'status' => 'required|numeric',
        ]);
        try {

            $create = DiscountProduct::where('id', $id)->first();
            $create->discount = $request->discount;
            $create->type = $request->type;
            $create->dis_amount = $request->dis_amount;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.discountProduct.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DiscountProduct::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }

    public function getMasterColors(Request $request)
    {
        $category = $request->category;

        $ColorMasters = ColorMaster::where('category_id', $category)->get();
        // $colors = Color::whereIn('id', explode(',', $ColorMaster))->orderBy('id', 'DESC')->get();

        return ['status' => 'success', 'data' => $ColorMasters];
    }
    public function getColors(Request $request)
    {
        $colorMaster = $request->colorMaster;

        $ColorMaster = ColorMaster::where('id', $colorMaster)->first();
        $colors = Color::whereIn('id', explode(',', $ColorMaster))->orderBy('id', 'DESC')->get();

        return ['status' => 'success', 'data' => $colors];
    }
}
