<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\FreeDesignContent;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;

class FreeDesignContentController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $FreeDesignContent = FreeDesignContent::first();
        if (!empty($FreeDesignContent)) {
            return view('backend.master.freeDesignContents.update', compact('FreeDesignContent'));
        } else {
            return view('backend.master.freeDesignContents.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.freeDesignContents.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',
            'title_one' => 'required',
            'title_two' => 'required',
            'title_three' => 'required',
            'title_four' => 'required',
            'title_five' => 'required',
            'description_one' => 'required',
            'description_two' => 'required',
            'description_three' => 'required',
            'button_url_one' => 'required',
            'button_url_two' => 'required',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'FreeDesignContent';
                $one['save_path'] = 'FreeDesignContent';
                $image = $this->save($one);
            }

            $create = new FreeDesignContent();
            $create->image = $image;
            $create->title_one = $request->title_one;
            $create->title_two = $request->title_two;
            $create->title_three = $request->title_three;
            $create->title_four = $request->title_four;
            $create->title_five = $request->title_five;
            $create->description_one = $request->description_one;
            $create->description_two = $request->description_two;
            $create->description_three = $request->description_three;
            $create->button_url_one = $request->button_url_one;
            $create->button_url_two = $request->button_url_two;
            $create->save();

            return redirect()->route('backend.freeDesignContent.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $FreeDesignContent = FreeDesignContent::where('id', $id)->first();
        return view('backend.master.freeDesignContents.update', compact('FreeDesignContent'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max size must have 1024.'
        ];

        $request->validate([
            'title_one' => 'required',
            'title_two' => 'required',
            'title_three' => 'required',
            'title_four' => 'required',
            'title_five' => 'required',
            'description_one' => 'required',
            'description_two' => 'required',
            'description_three' => 'required',
            'button_url_one' => 'required',
            'button_url_two' => 'required',
        ]);
        try {
            $FreeDesignContent = FreeDesignContent::where('id', $id)->first();

            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'FreeDesignContent';
                $data['save_path'] = '/FreeDesignContent';
                $data['old_image']=$FreeDesignContent->image;
                $image = $this->save($data);
                $FreeDesignContent->image = $image;
            }
            $FreeDesignContent->title_one = $request->title_one;
            $FreeDesignContent->title_two = $request->title_two;
            $FreeDesignContent->title_three = $request->title_three;
            $FreeDesignContent->title_four = $request->title_four;
            $FreeDesignContent->title_five = $request->title_five;
            $FreeDesignContent->description_one = $request->description_one;
            $FreeDesignContent->description_two = $request->description_two;
            $FreeDesignContent->description_three = $request->description_three;
            $FreeDesignContent->button_url_one = $request->button_url_one;
            $FreeDesignContent->button_url_two = $request->button_url_two;
            $FreeDesignContent->save();

            return redirect()->route('backend.freeDesignContent.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
