<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\GeneralAssembly;
use App\Models\GeneralAssemblyVideo;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class GeneralAssemblyVideoController extends Controller
{
    use ImageUploadTrait;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = GeneralAssemblyVideo::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['generalAssembly'] = $item->generalAssembly->name;
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    $nestedData['name'] = $item->name;
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.generalAssemblyVideo.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.generalAssemblyVideo.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $generalAssemblies = GeneralAssembly::where('status', 1)->get();
        return view('backend.master.generalAssemblyVideo.create', compact('generalAssemblies'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',
            'name' => 'required',
            'generalAssembly' => 'required',
            'youtube_link' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'generalAssemblyVideo';
                $one['save_path'] = 'generalAssemblyVideo';
                $image = $this->save($one);
            }

            $create = new GeneralAssemblyVideo();
            $create->name = $request->name;
            $create->general_assembly_id = $request->generalAssembly;
            $create->youtube_link = $request->youtube_link;
            $create->image = $image;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.generalAssemblyVideo.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $video = GeneralAssemblyVideo::where('id', $id)->first();
        $generalAssemblies = GeneralAssembly::where('status', 1)->get();
        return view('backend.master.generalAssemblyVideo.update', compact('video', 'generalAssemblies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max size must have 1024.'
        ];

        $request->validate([
            'name' => 'required',
            'generalAssembly' => 'required',
            'youtube_link' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            $store = GeneralAssemblyVideo::where('id', $id)->first();
            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'generalAssemblyVideo';
                $data['save_path'] = '/generalAssemblyVideo';
                $data['old_image']=$store->image;
                $image = $this->save($data);
                $store->image = $image;
            }

            $store->general_assembly_id = $request->generalAssembly;
            $store->youtube_link = $request->youtube_link;
            $store->name = $request->name;
            $store->status = $request->status;
            $store->save();

            return redirect()->route('backend.generalAssemblyVideo.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        GeneralAssemblyVideo::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
