<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Guaranteed;
use Exception;
use Illuminate\Http\Request;

class GuaranteedController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $guaranteed = Guaranteed::first();
        if (!empty($guaranteed)) {
            return view('backend.master.guaranteed.update', compact('guaranteed'));
        } else {
            return view('backend.master.guaranteed.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.guaranteed.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'shot_title' => 'required',
            'title' => 'required',
            'description' => 'required',
        ]);
        try {


            $create = new Guaranteed();
            $create->title = $request->title;
            $create->shot_title = $request->shot_title;
            $create->description = $request->description;
            $create->save();

            return redirect()->route('backend.guaranteed.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $guaranteed = Guaranteed::where('id', $id)->first();
        return view('backend.master.guaranteed.update', compact('guaranteed'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'shot_title' => 'required',
            'title' => 'required',
            'description' => 'required',
        ]);
        try {
            $guaranteed = Guaranteed::where('id', $id)->first();
            $guaranteed->title = $request->title;
            $guaranteed->shot_title = $request->shot_title;
            $guaranteed->description = $request->description;
            $guaranteed->save();

            return redirect()->route('backend.guaranteed.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
