<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\KitchenDesignTool;
use App\Traits\ImageUploadTrait;
use Illuminate\Http\Request;

class KitchenDesignToolCotroller extends Controller
{
    use ImageUploadTrait;
    public function kitchen_design_tool_show()
    {
        $assemblyIsntructions = KitchenDesignTool::first();
        return view('backend.master.kitchen_design_tools.update',compact('assemblyIsntructions'));
    }

    public function kitchen_design_tool_update(Request $request)
    {
        $assemblyIsntructions = KitchenDesignTool::first();
        if (empty($assemblyIsntructions)){
            $assemblyIsntructions = new KitchenDesignTool();
        }
        if (isset($request->image1) && !empty($request->image1)) {
            $data['image'] = $request->image1;
            $data['path'] = 'kitchen';
            $data['save_path'] = '/kitchen';
            $data['old_image']=$assemblyIsntructions->image_one;
            $image = $this->save($data);
            $assemblyIsntructions->image_one = $image;
        }
        if (isset($request->image2) && !empty($request->image2)) {
            $data['image'] = $request->image2;
            $data['path'] = 'kitchen';
            $data['save_path'] = '/kitchen';
            $data['old_image']= $assemblyIsntructions->image_two;
            $image = $this->save($data);
            $assemblyIsntructions->image_two = $image;
        }
        $assemblyIsntructions->title_one = $request->title;
        $assemblyIsntructions->title_two = $request->title_two;
        $assemblyIsntructions->description_two = $request->shot_description;
        $assemblyIsntructions->button_url = $request->button_url;
        $assemblyIsntructions->title_three = $request->title_three;
        $assemblyIsntructions->description_three = $request->description_three;
        $assemblyIsntructions->contact_number = $request->contact_number;
        $assemblyIsntructions->save();
        return redirect()->back()->with('success','Item(s) updated successfully.');
    }
}
