<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\AboutAddMor;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class AboutAddMorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = AboutAddMor::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['name'] = $item->name ?? '-';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.aboutAddMor.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.aboutAddMor.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.aboutAddMor.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $create = new AboutAddMor();
            $create->name = $request->name;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.aboutAddMor.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AboutAddMor  $aboutAddMor
     * @return \Illuminate\Http\Response
     */
    public function show(AboutAddMor $aboutAddMor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AboutAddMor  $aboutAddMor
     * @return \Illuminate\Http\Response
     */
    public function edit(AboutAddMor $aboutAddMor)
    {

        return view('backend.master.aboutAddMor.update', compact('aboutAddMor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AboutAddMor  $aboutAddMor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AboutAddMor $aboutAddMor)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            $aboutAddMor->name = $request->name;
            $aboutAddMor->status = $request->status;
            $aboutAddMor->save();

            return redirect()->route('backend.aboutAddMor.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AboutAddMor  $aboutAddMor
     * @return \Illuminate\Http\Response
     */
    public function destroy(AboutAddMor $aboutAddMor)
    {
        $aboutAddMor->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
