<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\AssemblyIsntructions;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;

class AssemblyIsntructionsController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $assemblyIsntructions = AssemblyIsntructions::first();
        if (!empty($assemblyIsntructions)) {
            return view('backend.master.assembly_isntruction.update', compact('assemblyIsntructions'));
        } else {
            return view('backend.master.assembly_isntruction.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.assembly_isntruction.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image1' => 'required',
            'image2' => 'required',
            'image3' => 'required',
            'title' => 'required',
            'video' => 'required',
            'shot_description' => 'required',
        ]);
        try {
            if (isset($request->image1) && !empty($request->image1)) {
                $one['image'] = $request->image1;
                $one['path'] = 'image1';
                $one['save_path'] = 'image1';
                $image1 = $this->save($one);
            }
            if (isset($request->image2) && !empty($request->image2)) {
                $one['image'] = $request->image2;
                $one['path'] = 'image2';
                $one['save_path'] = 'image2';
                $image2 = $this->save($one);
            }
            if (isset($request->image3) && !empty($request->image3)) {
                $one['image'] = $request->image3;
                $one['path'] = 'image3';
                $one['save_path'] = 'image3';
                $image3 = $this->save($one);
            }
            $create = new AssemblyIsntructions();
            $create->title = $request->title ?? null;
            $create->video = $request->video ?? null;
            $create->image1 = $image1;
            $create->image2 = $image2;
            $create->image3 = $image3;
            $create->shot_description = $request->shot_description ?? null;
            $create->save();

            return redirect()->route('backend.assemblyInstruction.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AssemblyIsntructions  $assemblyIsntructions
     * @return \Illuminate\Http\Response
     */
    public function show(AssemblyIsntructions $assemblyIsntructions)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AssemblyIsntructions  $assemblyIsntructions
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $assemblyIsntructions = AssemblyIsntructions::where('id', $id)->first();
        return view('backend.master.assembly_isntruction.update', compact('assemblyIsntructions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AssemblyIsntructions  $assemblyIsntructions
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'title' => 'required',
            'video' => 'required',
            'shot_description' => 'required',
        ]);


        try {
            $assemblyIsntructions = AssemblyIsntructions::where('id', $id)->first();
            if (isset($request->image1) && !empty($request->image1)) {
                $one['image'] = $request->image1;
                $one['path'] = 'image1';
                $one['save_path'] = 'image1';
                $one['old_image'] = $assemblyIsntructions->image1;
                $image1 = $this->save($one);
                $assemblyIsntructions->image1 = $image1;
            }
            if (isset($request->image2) && !empty($request->image2)) {
                $one['image'] = $request->image2;
                $one['path'] = 'image2';
                $one['save_path'] = 'image2';
                $one['old_image'] = $assemblyIsntructions->image2;
                $image2 = $this->save($one);
                $assemblyIsntructions->image2 = $image2;
            }
            if (isset($request->image3) && !empty($request->image3)) {
                $one['image'] = $request->image3;
                $one['path'] = 'image3';
                $one['save_path'] = 'image3';
                $one['old_image'] = $assemblyIsntructions->image3;
                $image3 = $this->save($one);
                $assemblyIsntructions->image3 = $image3;
            }
            $assemblyIsntructions->title = $request->title ?? null;
            $assemblyIsntructions->video = $request->video ?? null;
            $assemblyIsntructions->shot_description = $request->shot_description ?? null;
            $assemblyIsntructions->save();

            return redirect()->route('backend.assemblyInstruction.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AssemblyIsntructions  $assemblyIsntructions
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        AssemblyIsntructions::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
