<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class BannerController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Banner::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    // $nestedData['title'] = (strlen($item->title) > 20) ? substr($item->title, 0, 20) . '...' : $item->title;
                    // $nestedData['description'] = (strlen($item->description) > 30) ? substr($item->description, 0, 30) . '...' : $item->description;
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.banner.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.banner.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.banner.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image',
            'title1' => 'required',
            'title2' => 'required',
            'title3' => 'required',
            'title4' => 'required',
            'title5' => 'required',
            'title6' => 'required',
            'color' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'banner';
                $one['save_path'] = 'banner';
                $image = $this->save($one);
            }

            $create = new Banner();
            $create->title1 = $request->title1;
            $create->title2 = $request->title2;
            $create->title3 = $request->title3;
            $create->title4 = $request->title4;
            $create->title5 = $request->title5;
            $create->title6 = $request->title6;
            $create->title7 = $request->title7;
            $create->image = $image;
            // $create->description = $request->description;
            $create->color = $request->color;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.banner.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function show(Banner $banner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function edit(Banner $banner)
    {

        return view('backend.master.banner.update', compact('banner'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Banner $banner)
    {
        $msg = [
            'image.max' => 'Please select image'
        ];

        $request->validate([
            'title1' => 'required',
            'title2' => 'required',
            'title3' => 'required',
            'title4' => 'required',
            'title5' => 'required',
            'title6' => 'required',
            'color' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'banner';
                $data['save_path'] = '/banner';
                $data['old_image']=$banner->image;
                $image = $this->save($data);
                $banner->image = $image;
            }

            $banner->title1 = $request->title1;
            $banner->title2 = $request->title2;
            $banner->title3 = $request->title3;
            $banner->title4 = $request->title4;
            $banner->title5 = $request->title5;
            $banner->title6 = $request->title6;
            $banner->title7 = $request->title7;
            $banner->color = $request->color;
            $banner->status = $request->status;
            $banner->save();

            return redirect()->route('backend.banner.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function destroy(Banner $banner)
    {
        $banner->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
