<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;

class BlogController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Blog::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    if (!empty($item->date)) {
                        $nestedData['date'] = $item->date;
                    } else {
                        $nestedData['date'] = '-';
                    }
                    $nestedData['title'] = (strlen($item->title) > 20) ? substr($item->title, 0, 20) . '...' : $item->title;
                    $nestedData['description'] = (strlen($item->description) > 150) ? substr(strip_tags($item->description), 0, 150) . '...' : strip_tags($item->description);
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.blog.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.blog.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.blog.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image',
            'title' => 'required',
            'date' => 'required',
            'description' => 'required',
            'status' => 'required|numeric',
            'meta_description' => 'required',
            'meta_title' => 'required',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'blog';
                $one['save_path'] = 'blog';
                $image = $this->save($one);
            }

            $create = new Blog();
            $create->title = $request->title;
            $create->date = $request->date;
            $create->slug = Str::slug($request->title, "-");
            $create->image = $image;
            $create->description = $request->description;
            $create->meta_description = $request->meta_description;
            $create->meta_title = $request->meta_title;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.blog.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(Blog $blog)
    {

        return view('backend.master.blog.update', compact('blog'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Blog $blog)
    {
        $msg = [
            'image.max' => 'The image max must size have 1024.'
        ];

        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'status' => 'required|numeric',
            'date' => 'required',
            'meta_description' => 'required',
            'meta_title' => 'required',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'blog';
                $data['save_path'] = '/blog';
                $data['old_image']=$blog->image;
                $image = $this->save($data);
                $blog->image = $image;
            }

            $blog->title = $request->title;
            $blog->description = $request->description;
            $blog->date = $request->date;
            $blog->slug = Str::slug($request->title, "-");
            $blog->status = $request->status;
            $blog->meta_description = $request->meta_description;
            $blog->meta_title = $request->meta_title;
            $blog->save();

            return redirect()->route('backend.blog.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy(Blog $blog)
    {
        $blog->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
