<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Color;
use App\Models\ColorMaster;
use App\Models\Type;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ColorMasterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = ColorMaster::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();
            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $colors = Color::whereIn('id', explode(',', $item->color_id))->pluck('name')->toArray();
                    $category = Type::where('id', $item->category_id)->value('name');

                    $nestedData['name'] = $item->name ?? '-';
                    $nestedData['category_name'] = $category ?? '-';
                    $nestedData['color_id'] = (string)View::make('backend.master.colorMaster.color', ['colors' => $colors])->render();
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.colorMaster.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.colorMaster.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $colors = Color::where('status', 1)->get();
        $types = Type::where('status', 1)->get();
        return view('backend.master.colorMaster.create', compact('colors', 'types'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'color_id' => 'required',
            'type_id' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $create = new ColorMaster();
            $create->name = $request->name ?? null;
            $create->category_id = $request->type_id ?? null;
            $create->color_id = implode(',', $request->color_id) ?? null;
            $create->status = $request->status ?? null;
            $create->save();


            return redirect()->route('backend.colorMaster.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $colors = Color::where('status', 1)->get();
        $colorMaster = ColorMaster::where('id', $id)->first();
        $types = Type::where('status', 1)->get();
        return view('backend.master.colorMaster.update', compact('colors', 'colorMaster', 'types'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'name' => 'required',
            'color_id' => 'required',
            'type_id' => 'required',
            'status' => 'required|numeric',
        ]);
        try {

            $colorMaster = ColorMaster::where('id', $id)->first();
            $colorMaster->name = $request->name ?? null;
            $colorMaster->category_id = $request->type_id ?? null;
            $colorMaster->color_id = implode(', ', $request->color_id) ?? null;
            $colorMaster->status = $request->status ?? null;
            $colorMaster->save();


            return redirect()->route('backend.colorMaster.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        ColorMaster::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
