<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\ConstructionType;
use App\Models\ProductType;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ConstructionTypeController extends Controller
{
    use ImageUploadTrait;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
  $query = ProductType::when($request->all()['search']['value'], function ($query) use ($request) {
                return $query->where('name', 'like', '%' . $request->all()['search']['value'] . '%');
            })->orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    $nestedData['name'] = $item->name ?? '-';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.constructionType.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.constructionType.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.constructionType.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',
            'name' => 'required',
            'status' => 'required|numeric',

        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'product';
                $one['save_path'] = 'product';
                $image = $this->save($one);
            }

            $create = new ProductType();
            $create->name = $request->name ?? null;
            $create->image = $image;
            $create->status = $request->status ?? null;
            $create->save();

            return redirect()->route('backend.construction.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\ConstructionType $constructionType
     * @return \Illuminate\Http\Response
     */
    public function show(ConstructionType $constructionType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\ConstructionType $constructionType
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $productType = ProductType::where('id', $id)->first();
        return view('backend.master.constructionType.update', compact('productType'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Models\ConstructionType $constructionType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max size must have 1024.'
        ];
        $request->validate([
            'name' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            $constructionType = ProductType::where('id', $id)->first();

            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'product';
                $data['save_path'] = '/product';
                $data['old_image']=$constructionType->image;
                $image = $this->save($data);
                $constructionType->image = $image;
            }

            $constructionType->name = $request->name ?? null;
            $constructionType->status = $request->status ?? null;
            $constructionType->save();

            return redirect()->route('backend.construction.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\ConstructionType $constructionType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        ProductType::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
