<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Gallery;
use App\Models\OurServisesMaster;
use App\Models\Type;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class GalleryController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Gallery::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {

                    $type = Type::where('id', $item->type_id)->first();
                    $OurServisesMaster = OurServisesMaster::where('id', $item->ourservisesmaster_id)->first();

                    $nestedData['type'] = $type->name ?? '-';
                    $nestedData['ourServisesMaster'] = $OurServisesMaster->name ?? '-';

                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.gallery.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.gallery.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $types = Type::where('status', 1)->get();
        $OurServisesMasters = OurServisesMaster::where('status', 1)->get();

        return view('backend.master.gallery.create', compact('types', 'OurServisesMasters'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',
            'type' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'gallery';
                $one['save_path'] = 'gallery';
                $image = $this->save($one);
            }

            $create = new Gallery();
            $create->type = $request->type;
            $create->ourservisesmaster_id = $request->ourservisesmaster_id;
            $create->type_id = $request->type_id;
            $create->image = $image;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.gallery.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $gallery = Gallery::where('id', $id)->first();
        $types = Type::where('status', 1)->get();
        $OurServisesMasters = OurServisesMaster::where('status', 1)->get();

        return view('backend.master.gallery.update', compact('gallery', 'types', 'OurServisesMasters'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max must size have 1024.'
        ];

        $request->validate([
            'type' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            $gallery = Gallery::where('id', $id)->first();

            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'gallery';
                $data['save_path'] = '/gallery';
                $data['old_image']=$gallery->image;
                $image = $this->save($data);
                $gallery->image = $image;
            }
            if ($request->type == 1) {
                $gallery->type_id = $request->type_id;
                $gallery->ourservisesmaster_id = null;
            } else {
                $gallery->ourservisesmaster_id = $request->ourservisesmaster_id;
                $gallery->type_id = null;
            }
            $gallery->type = $request->type;
            $gallery->status = $request->status;
            $gallery->save();

            return redirect()->route('backend.gallery.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Gallery::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
