<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\OurServisesMaster;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class OurServisesMasterController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = OurServisesMaster::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image1'] = '<img src="' . asset($item->image1) . '" class="type-1">';
                    $nestedData['image2'] = '<img src="' . asset($item->image2) . '" class="type-1">';
                    $nestedData['name'] = $item->name ?? '-';
                    $nestedData['title'] = $item->title ?? '-';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.ourServisesMaster.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.ourServisesMaster.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.ourServisesMaster.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image1' => 'required|image|max:1024',
            'image2' => 'required|image|max:1024',
            'name' => 'required',
            'title' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            if (isset($request->image1) && !empty($request->image1)) {
                $one['image'] = $request->image1;
                $one['path'] = 'ourServisesMaster';
                $one['save_path'] = 'ourServisesMaster';
                $image1 = $this->save($one);
            }
            if (isset($request->image2) && !empty($request->image2)) {
                $one['image'] = $request->image2;
                $one['path'] = 'ourServisesMaster';
                $one['save_path'] = 'ourServisesMaster';
                $image2 = $this->save($one);
            }
            $create = new OurServisesMaster();
            $create->image1 = $image1;
            $create->image2 = $image2;
            $create->name = $request->name;
            $create->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $request->name)));
            $create->title = $request->title;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.ourServicesMaster.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ourServisesMaster = OurServisesMaster::where('id', $id)->first();
        return view('backend.master.ourServisesMaster.update', compact('ourServisesMaster'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image1.max' => 'The image max size must have 1024.',
            'image2.max' => 'The image max size must have 1024.',
        ];
        $request->validate([
            'name' => 'required',
            'title' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            $ourServisesMaster = OurServisesMaster::where('id', $id)->first();
            if (isset($request->image1) && !empty($request->image1)) {
                $request->validate([
                    'image1' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image1;
                $data['path'] = 'ourServisesMaster';
                $data['save_path'] = 'ourServisesMaster';
                $data['old_image']=$ourServisesMaster->image1;
                $image1 = $this->save($data);
                $ourServisesMaster->image1 = $image1;
            }
            if (isset($request->image2) && !empty($request->image2)) {
                $request->validate([
                    'image2' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image2;
                $data['path'] = 'ourServisesMaster';
                $data['save_path'] = 'ourServisesMaster';
                $data['old_image']=$ourServisesMaster->image2;
                $image2 = $this->save($data);
                $ourServisesMaster->image2 = $image2;
            }
            $ourServisesMaster->name = $request->name;
//            $ourServisesMaster->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $request->name)));
            $ourServisesMaster->title = $request->title;
            $ourServisesMaster->status = $request->status;
            $ourServisesMaster->save();

            return redirect()->route('backend.ourServicesMaster.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        OurServisesMaster::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
