<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Color;
use App\Models\ConstructionType;
use App\Models\Product;
use App\Models\ProductCombination;
use App\Models\Tag;
use App\Models\Type;
use Exception;
use Illuminate\Http\Request;

class ProductCSVUplodeController extends Controller
{
    public function add()
    {
        return view('backend.master.product.productCSV.add');
    }

    public function import(Request $request)
    {
        $msg = [
            'csv.required' => 'Please upload CSV file.'
        ];
        $request->validate([
            'csv' => 'required',
        ], $msg);

        try {
            if (!empty($request->csv)) {
                $implode = [];
                $handle = fopen($request->csv, "r");
                while (($dataCsv = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $implode[] = $dataCsv;
                }
                if (!empty($implode)) {
                    foreach ($implode as $key => $value) {
                        if ($key > 0) {

                            $value = mb_convert_encoding($value, 'UTF-8', 'UTF-8');
                            $typeData = Type::where('name', $value[4])->first();

                            if (!empty($typeData)) {
                                $type_id = $typeData->id;
                            } else {
                                $type_id = new Type();
                                $type_id->name = $value[4];
                                $type_id->status = 1;
                                $type_id->save();
                            }
                            // $color_ids = [];
                            // $colors = explode('-', $value[5]);
                            // if (!empty($colors)) {
                            //     foreach ($colors as $colorName) {

                            //         $color = Color::where('name', $colorName)->first();
                            //         if (!empty($color)) {
                            //             $color_ids[] = $color->id;
                            //         } else {
                            //             $color_id = new Color();
                            //             $color_id->name = $colorName;
                            //             $color_id->status = 1;
                            //             $color_id->save();
                            //             $color_ids[] = $color_id->id;
                            //         }
                            //     }
                            // }
                            $constructionTypeData = ConstructionType::where('title', $value[5])->first();

                            if (!empty($constructionTypeData)) {
                                $constructionTypeData_id = $constructionTypeData->id;
                            } else {
                                $constructionTypeData_id = new ConstructionType();
                                $constructionTypeData_id->title = $value[5];
                                $constructionTypeData_id->status = 1;
                                $constructionTypeData_id->save();
                            }

                            if ($value[7] == 'Active') {
                                $status = 1;
                            } else {
                                $status = 0;
                            }

                            $product = new Product();
                            $product->pdf = $value[0];
                            $product->name = $value[1];
                            $product->model_number = $value[2];
                            $product->video_link = $value[3];
                            $product->category = $type_id;
                            // $product->color_id = implode(',', $color_ids);
                            $product->construction_type = $constructionTypeData_id;
                            $product->description = $value[6];
                            $product->status = $status;
                            $product->save();
                        }
                    }
                }
                return redirect()->route('backend.product.index')->with('success', 'Product created successfully.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function add_comdication()
    {
        $products = Product::orderBy('id', 'desc')->get();
        return view('backend.master.product.productCSV.addCombination', compact('products'));
    }

    public function import_comdication(Request $request)
    {
        $msg = [
            'product_id.required' => 'Please select product.',
            'csv.required' => 'Please upload CSV file.'
        ];
        $request->validate([
            'product_id' => 'required',
            'csv' => 'required',
        ], $msg);

        $request->validate([

            'csv' => 'required',
        ]);

        try {
            if (!empty($request->csv)) {
                $implode = [];
                $handle = fopen($request->csv, "r");
                while (($dataCsv = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $implode[] = $dataCsv;
                }
                if (!empty($implode)) {
                    foreach ($implode as $key => $value) {
                        if ($key > 0) {
                            $value = mb_convert_encoding($value, 'UTF-8', 'UTF-8');
                            $tagData = Tag::where('name', $value[2])->first();
                            // $colorData = Color::where('name', $value[7])->first();
                            //                            if (!empty($tagData)) {
                            //                                $tag_id = $tagData->id;
                            //                            } else {
                            //                                $tag = new Tag();
                            //                                $tag->name = $value[2];
                            //                                $tag->status = 1;
                            //                                $tag->save();
                            //
                            //                                $tag_id = $tag->id;
                            //                            }

                            //                            if (!empty($colorData)) {
                            //                                $color_id = $colorData->id;
                            //                            } else {
                            //                                $color = new Tag();
                            //                                $color->name = $value[2];
                            //                                $color->status = 1;
                            //                                $color->save();
                            //
                            //                                $color_id = $tag->id;
                            //                            }

                            $tag_id = $tagData->id ?? null;
                            // $color_id = $colorData->id ?? null;
                            if ($value[5] == 'TRUE' || $value[5] == 'Yes') {
                                $inStock = 1;
                            } else {
                                $inStock = 0;
                            }
                            // if ($value[7] == 'Active') {
                            //     $status = 1;
                            // } else {
                            //     $status = 0;
                            // }

                            $data['product_id'] = $request->product_id;
                            $data['name'] = $value[0];
                            $data['dimension'] = str_replace('??', '”', $value[1]);
                            $data['tag_id'] = $tag_id;
                            // $data['color_id'] = $color_id;
                            $data['main_price'] = $value[3];
                            $data['discount_price'] = $value[4];
                            $data['in_stock'] = $inStock;
                            $data['image'] = $value[6];
                            $data['status'] = 1;
                            $data['all_data'] = 1;

                            ProductCombination::create($data);
                        }
                    }
                }
                $min_price = ProductCombination::where('product_id', $request->product_id)->min('main_price');
                $max_price = ProductCombination::where('product_id', $request->product_id)->max('main_price');
                $product = Product::where('id', $request->product_id)->first();
                $product->min_price = $min_price;
                $product->max_price = $max_price;
                $product->save();
                return redirect()->route('backend.product.index')->with('success', 'Product combinations created successfully.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
