<?php

namespace App\Http\Controllers\Backend\Master;

ini_set('max_input_vars', 18000);
ini_set('memory_limit', '-1');

use App\Http\Controllers\Controller;
use App\Models\Color;
use App\Models\Length;
use App\Models\Product;
use App\Models\ProductCombination;
use App\Models\ProductType;
use App\Models\Tag;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class ProductCombinationAccController extends Controller
{
    use ImageUploadTrait;

    public function add(Request $request, $id)
    {
        $product = $id;
        $product_data = Product::find($product);
        $colors = Color::where('status', 1)->get();
        $lengths = Length::where('status', 1)->get();
        if ($request->ajax()) {
            $count = $request->query()['count'] ?? null;
            $view = view('backend.master.product.combination_ass.row', compact('product', 'colors', 'lengths', 'count'))->render();
            return response()->json(['html' => $view]);
        }
        $combinitions = ProductCombination::where('product_id', $id)->paginate(25);
        $count = 0;

        return view('backend.master.product.combination_ass.add', compact('product', 'colors', 'lengths', 'combinitions', 'count'));
    }

    public function store(Request $request)
    {

        try {
            $combinitions = ProductCombination::where('product_id', $request->product_id)->get();
            if (!empty($combinitions)) {
                foreach ($combinitions as $key => $combinition) {
                    if (!empty($request['color_id_' . $combinition->id]) && !empty($request['main_price_' . $combinition->id])) {
                        if (!empty($request['images_' . $combinition->id])) {
                            // dd($request->all(), $combinition, $request['images_' . $combinition->id]);
                            $one['image'] = $request['images_' . $combinition->id];
                            $one['path'] = 'product';
                            $one['save_path'] = 'product';
                            $data['old_image']=$combinition->image;
                            $image = $this->save($one);
                            $combinition->image = $image;
                        }
                        $combinition->length_id = $request['length_id_' . $combinition->id];
                        $combinition->color_id = $request['color_id_' . $combinition->id];
                        $combinition->main_price = $request['main_price_' . $combinition->id];
                        $combinition->discount_price = $request['discount_price_' . $combinition->id];
                        $combinition->in_stock = $request['in_stock_' . $combinition->id];
                        $combinition->status = $request['status_' . $combinition->id];
                        $combinition->save();
                    }
                }
            }
            if (isset($request->images) && !empty($request->images)) {

                foreach ($request->images as $key => $img) {
                    if (!empty($img)) {
                        $one['image'] = $img;
                        $one['path'] = 'product';
                        $one['save_path'] = 'product';
                        $image = $this->save($one);
                        $pCombination = new ProductCombination();
                        $pCombination->product_id = $request->product_id;
                        $pCombination->image = $image;
                        $pCombination->length_id = $request->length_id[$key];
                        $pCombination->color_id = $request->color_id[$key];
                        $pCombination->main_price = $request->main_price[$key];
                        $pCombination->discount_price = $request->discount_price[$key];
                        $pCombination->in_stock = $request->in_stock[$key];
                        $pCombination->status = $request->status[$key];
                        $pCombination->save();
                    }
                }
            }
            $min_price = ProductCombination::where('product_id', $request->product_id)->min('main_price');
            $max_price = ProductCombination::where('product_id', $request->product_id)->max('main_price');

            Product::where('id', $request->product_id)->update([
                'min_price' => $min_price,
                'max_price' => $max_price,
            ]);
            return redirect()->back()->with('success', 'Product combination created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function delete($id)
    {
        ProductCombination::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }

    public function import(Request $request)
    {
        $msg = [
            'csv.required' => 'Please upload CSV file.'
        ];
        $request->validate([
            'csv' => 'required',
        ], $msg);

        try {
            if (!empty($request->csv)) {
                $implode = [];
                $handle = fopen($request->csv, "r");
                while (($dataCsv = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $implode[] = $dataCsv;
                }
                if (!empty($implode)) {
                    foreach ($implode as $key => $value) {
                        if ($key > 0) {
                            $value = mb_convert_encoding($value, 'UTF-8', 'UTF-8');
                            $lengthData = Length::where('name', $value[0])->first();
                            $colorData = Color::where('name', $value[1])->first();
                            $length_id = $lengthData->id ?? null;
                            $color_id = $colorData->id ?? null;
                            if ($value[5] == 'TRUE' || $value[5] == 'Yes' || $value[5] == 'yes' || $value[5] == 'YES') {
                                $inStock = 1;
                            } else {
                                $inStock = 0;
                            }

                            $data['product_id'] = $request->product_id;
                            $data['length_id'] = $length_id;
                            $data['color_id'] = $color_id;
                            $data['main_price'] = $value[3];
                            $data['image'] = $value[2];
                            $data['discount_price'] = $value[4];
                            $data['in_stock'] = $inStock;
                            $data['status'] = 1;
                            $data['all_data'] = 1;

                            ProductCombination::create($data);
                        }
                    }
                }
                $min_price = ProductCombination::where('product_id', $request->product_id)->min('main_price');
                $max_price = ProductCombination::where('product_id', $request->product_id)->max('main_price');

                $product = Product::where('id', $request->product_id)->first();
                $product->min_price = $min_price;
                $product->max_price = $max_price;
                $product->save();
                return redirect()->back()->with('success', 'Product combinations created successfully.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function export(Request $request)
    {

        $datas = ProductCombination::where('product_id', $request->product_id)->get();

        $csvFileName = 'Combination_ass.csv';
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=$csvFileName",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );

        $callback = function () use ($datas) {
            $file = fopen('php://output', 'w');

            // Add CSV Headers
            fputcsv($file, ['Length', 'Color', 'Images',  'Main Price', 'Discount Price', 'In stock', 'Status']);;
            // Add data rows
            foreach ($datas as $data) {
                $inStock = ($data->in_stock == 1) ? 'Yes' : 'No';
                $status = ($data->status == 1) ? 'Active' : 'Inactive';
                $image = $data['image'] ?? null;
                $length = $data['length']['name'] ?? null;
                $main_price = $data['main_price'] ?? null;
                $discount_price = $data['discount_price'] ?? null;
                $color = $data['color']['name'] ?? null;
                fputcsv($file, [$length, $color, $image, $main_price, $discount_price, $inStock,  $status]);
            }

            fclose($file);
        };

        return Response::stream($callback, 200, $headers);
    }
    public function delete_all($id)
    {
        ProductCombination::where('product_id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
    public function update(Request $request)
    {
        try {
            $combinition = ProductCombination::where('id', $request->combinition)->first();
            if (!empty($request->image)) {

                $image = 'product/' . $this->base64($request->image);
            } else {
                $image = $combinition->image;
            }

            $combinition->image = $image;
            $combinition->main_price = $request->main_price;
            $combinition->discount_price = $request->discount_price;
            $combinition->color_id = $request->color_id;
            $combinition->length_id = $request->length_id;
            $combinition->in_stock = $request->in_stock;
            $combinition->product_id = $combinition->product_id;
            $combinition->status = $request->status;
            $combinition->save();
            // dd($combinition);

            $min_price = ProductCombination::where('product_id', $combinition->product_id)->min('main_price');
            $max_price = ProductCombination::where('product_id', $combinition->product_id)->max('main_price');

            Product::where('id', $combinition->product_id)->update([
                'min_price' => $min_price,
                'max_price' => $max_price,
            ]);
            $data['combinition'] = $combinition;
            return response()->json(['status' => 'success', 'msg' => 'Product combination updated successfully.', 'data' => $data]);
        } catch (Exception $e) {
            return response()->json(['status' => 'error', 'msg' => $e->getMessage()]);
        }
    }
}
