<?php

namespace App\Http\Controllers\Backend\Master;

ini_set('max_input_vars', 18000);
ini_set('memory_limit', '-1');

use App\Http\Controllers\Controller;
use App\Models\Color;
use App\Models\Product;
use App\Models\ProductCombination;
use App\Models\ProductType;
use App\Models\Tag;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class ProductCombinationController extends Controller
{
    use ImageUploadTrait;

    public function add(Request $request, $id)
    {
        $product = $id;
        $product_data = Product::find($product);
        $tags = Tag::where('status', 1)->get();
        $productTypes = ProductType::where('status', 1)->get();
        // $colors = Color::whereIn('id', explode(',', $product_data->color_id))->where('status', 1)->get();
        if ($request->ajax()) {
            $count = $request->query()['count'] ?? null;
            $view = view('backend.master.product.combination.row', compact('product', 'tags', 'count'))->render();
            return response()->json(['html' => $view]);
        }
        $combinitions = ProductCombination::where('product_id', $id)->paginate(25);
        $count = 0;

        return view('backend.master.product.combination.add', compact('product', 'productTypes', 'tags', 'combinitions', 'count'));
    }

    public function store(Request $request)
    {
        try {
            $combinitions = ProductCombination::where('product_id', $request->product_id)->get();
            if (!empty($combinitions)) {
                foreach ($combinitions as $key => $combinition) {
                    //                    if (!empty($request['images_' . $combinition->id])) {
                    //                        $one['image'] = $request['images_' . $combinition->id];
                    //                        $one['path'] = 'product';
                    //                        $one['save_path'] = 'product';
                    //                        $image = $this->save($one);
                    //                    } else {
                    //                        $image = $combinition->image;
                    //                    }
                    //                    $combinition->image = $image;
                    if (!empty($request['name_' . $combinition->id]) && !empty($request['dimension_' . $combinition->id]) && !empty($request['main_price_' . $combinition->id])) {
                        $combinition->name = $request['name_' . $combinition->id];
                        $combinition->dimension = $request['dimension_' . $combinition->id];
                        $combinition->main_price = $request['main_price_' . $combinition->id];
                        $combinition->discount_price = $request['discount_price_' . $combinition->id];
                        $combinition->tag_id = $request['tag_id_' . $combinition->id];
                        // $combinition->color_id = $request['color_id_' . $combinition->id];
                        $combinition->product_type_id = $request['product_type_id_' . $combinition->id];
                        $combinition->in_stock = $request['in_stock_' . $combinition->id];
                        $combinition->status = $request['status_' . $combinition->id];
                        $combinition->save();
                    }
                }
            }

            if (isset($request->name) && !empty($request->name)) {
                foreach ($request->name as $key => $name) {
                    if (!empty($name)) {
                        //                    $one['image'] = $img;
                        //                    $one['path'] = 'product';
                        //                    $one['save_path'] = 'product';
                        //                    $image = $this->save($one);

                        $pCombination = new ProductCombination();
                        $pCombination->product_id = $request->product_id;
                        //                    $pCombination->image = $image;
                        $pCombination->name = $name;
                        //                    $pCombination->name = $request->name[$key];
                        $pCombination->dimension = $request->dimension[$key];
                        $pCombination->main_price = $request->main_price[$key];
                        $pCombination->discount_price = $request->discount_price[$key];
                        $pCombination->tag_id = $request->tag_id[$key];
                        // $pCombination->color_id = $request->color_id[$key];
                        $pCombination->product_type_id = $request->product_type_id[$key];
                        $pCombination->in_stock = $request->in_stock[$key];
                        $pCombination->status = $request->status[$key];
                        $pCombination->save();
                    }
                }
            }
            $min_price = ProductCombination::where('product_id', $request->product_id)->min('main_price');
            $max_price = ProductCombination::where('product_id', $request->product_id)->max('main_price');

            Product::where('id', $request->product_id)->update([
                'min_price' => $min_price,
                'max_price' => $max_price,
            ]);
            return redirect()->back()->with('success', 'Product combination created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function delete($id)
    {
        ProductCombination::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }

    public function import(Request $request)
    {
        $msg = [
            'csv.required' => 'Please upload CSV file.'
        ];
        $request->validate([
            'csv' => 'required',
        ], $msg);

        try {
            if (!empty($request->csv)) {
                $implode = [];
                $handle = fopen($request->csv, "r");
                while (($dataCsv = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $implode[] = $dataCsv;
                }
                if (!empty($implode)) {
                    foreach ($implode as $key => $value) {
                        if ($key > 0) {
                            $value = mb_convert_encoding($value, 'UTF-8', 'UTF-8');
                            $tagData = Tag::where('name', $value[2])->first();
                            $productTypeData = ProductType::where('name', $value[3])->first();

                            // $colorData = Color::where('name', $value[7])->first();
                            //                            if (!empty($tagData)) {
                            //                                $tag_id = $tagData->id;
                            //                            } else {
                            //                                $tag = new Tag();
                            //                                $tag->name = $value[2];
                            //                                $tag->status = 1;
                            //                                $tag->save();
                            //
                            //                                $tag_id = $tag->id;
                            //                            }

                            //                            if (!empty($colorData)) {
                            //                                $color_id = $colorData->id;
                            //                            } else {
                            //                                $color = new Tag();
                            //                                $color->name = $value[2];
                            //                                $color->status = 1;
                            //                                $color->save();
                            //
                            //                                $color_id = $tag->id;
                            //                            }

                            $tag_id = $tagData->id ?? null;
                            $productType_id = $productTypeData->id ?? null;
                            if ($value[6] == 'TRUE' || $value[6] == 'Yes' || $value[6] == 'yes' || $value[6] == 'YES') {
                                $inStock = 1;
                            } else {
                                $inStock = 0;
                            }
                            // if ($value[7] == 'Active') {
                            //     $status = 1;
                            // } else {
                            //     $status = 0;
                            // }

                            $data['product_id'] = $request->product_id;
                            $data['name'] = $value[0];
                            $data['dimension'] = str_replace('??', '”', $value[1]);
                            $data['tag_id'] = $tag_id;
                            $data['product_type_id'] = $productType_id;
                            $data['main_price'] = $value[4];
                            $data['discount_price'] = $value[5];
                            $data['in_stock'] = $inStock;
                            // $data['image'] = $value[6];
                            $data['status'] = 1;
                            $data['all_data'] = 1;

                            ProductCombination::create($data);
                        }
                    }
                }
                $min_price = ProductCombination::where('product_id', $request->product_id)->min('main_price');
                $max_price = ProductCombination::where('product_id', $request->product_id)->max('main_price');

                $product = Product::where('id', $request->product_id)->first();
                $product->min_price = $min_price;
                $product->max_price = $max_price;
                $product->save();
                return redirect()->back()->with('success', 'Product combinations created successfully.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function export(Request $request)
    {

        $datas = ProductCombination::where('product_id', $request->product_id)->get();

        $csvFileName = 'Combination.csv';
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=$csvFileName",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );

        $callback = function () use ($datas) {
            $file = fopen('php://output', 'w');

            // Add CSV Headers
            fputcsv($file, ['SKU', 'Description', 'Tag', 'Product type', 'Main Price', 'Discount Price', 'In stock', 'Status']);;
            // Add data rows
            foreach ($datas as $data) {
                $inStock = ($data->in_stock == 1) ? 'Yes' : 'No';
                $status = ($data->status == 1) ? 'Active' : 'Inactive';
                $productType = $data['productType']['name'] ?? null;
                $name = $data['name'] ?? null;
                $dimension = $data['dimension'] ?? null;
                $main_price = $data['main_price'] ?? null;
                $discount_price = $data['discount_price'] ?? null;
                $tag = $data['tag']['name'] ?? null;
                // $color = $data['color']['name'] ?? null;
                fputcsv($file, [$name, $dimension, $tag, $productType, $main_price, $discount_price, $inStock,  $status]);
            }

            fclose($file);
        };

        return Response::stream($callback, 200, $headers);
    }
    public function delete_all($id)
    {
        ProductCombination::where('product_id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
    public function update(Request $request)
    {

        try {
            $combinition = ProductCombination::where('id', $request->combinition)->first();
            // if (!empty($request->image)) {

            //     $image = 'product/' . $this->base64($request->image);
            // } else {
            //     $image = $combinition->image;
            // }

            // $combinition->image = $image;
            $combinition->name = $request->name;
            $combinition->dimension = $request->dimension;
            $combinition->main_price = $request->main_price;
            $combinition->discount_price = $request->discount_price;
            $combinition->tag_id = $request->tag_id;
            $combinition->product_type_id = $request->product_type_id;
            $combinition->in_stock = $request->in_stock;
            $combinition->product_id = $combinition->product_id;
            $combinition->status = $request->status;
            $combinition->save();
            // dd($combinition);

            $min_price = ProductCombination::where('product_id', $combinition->product_id)->min('main_price');
            $max_price = ProductCombination::where('product_id', $combinition->product_id)->max('main_price');

            Product::where('id', $combinition->product_id)->update([
                'min_price' => $min_price,
                'max_price' => $max_price,
            ]);
            return response()->json(['status' => 'success', 'msg' => 'Product combination updated successfully.']);
        } catch (Exception $e) {
            return response()->json(['status' => 'error', 'msg' => $e->getMessage()]);
        }
    }
}
