<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Cabinet;
use App\Models\Cart;
use App\Models\Color;
use App\Models\ColorMaster;
use App\Models\ConstructionType;
use App\Models\Door;
use App\Models\Length;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\Type;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ProductController extends Controller
{
    use ImageUploadTrait;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Product::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();
            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $img = ProductImage::where('product_id', $item->id)->first();
                    $colors = Color::whereIn('id', explode(',', $item->color_id))->pluck('name')->toArray();
                    if (!empty($item->background_image)) {
                        $nestedData['background_image'] = '<img src="' . asset($item->background_image) . '" class="type-1">';
                    } else {
                        $nestedData['background_image'] = '-';
                    }
                    if (!empty($img)) {
                        $nestedData['image'] = '<img src="' . asset($img->image) . '" class="type-1">';
                    } else {
                        $nestedData['image'] = '-';
                    }
                    $nestedData['name'] = $item->name ?? '-';
                    //  $nestedData['cabinet'] = $item->cabinet->name ?? '-';
                    // $nestedData['model_number'] = $item->model_number ?? '-';
                    $nestedData['category'] = $item->type->name ?? '-';
                    $nestedData['color_master'] = $item->colorMaster->name ?? '-';
                    $nestedData['color'] = $item->color->name ?? '-';
                    $nestedData['color_id'] = (string)View::make('backend.master.product.color', ['colors' => $colors])->render();
                    //  $nestedData['door_style_id'] = $item->door->color_name ?? '-';


                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.product.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.product.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cabinets = Cabinet::where('status', 1)->get();
        $categories = Type::where('status', 1)->get();
        $colors = ColorMaster::where('status', 1)->get();
        $doors = Door::where('status', 1)->get();
        // $constructions = ConstructionType::where('status', 1)->get();
        $sort_order1 = Product::where('category', 1)->count() + 1;
        $sort_order2 = Product::where('category', '!=', 1)->count() + 1;
        return view('backend.master.product.create', compact('sort_order1', 'sort_order2', 'cabinets', 'categories', 'colors', 'doors'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            // 'background_image' => 'required',
            // 'cabinet_id' => 'required',
            //            'name' => 'required',
            // 'model_number' => 'required',
            // 'video_link' => 'required',
            // 'information' => 'required',
            'category' => 'required',
            // 'colorMaster_id' => 'required',
            // 'color' => 'required',
            // 'door_style_id' => 'required',
            // 'construction_type' => 'required',
            'description' => 'required',
            'status' => 'required|numeric',
            // 'sort_order' => 'required',
        ]);
        try {
            $create = new Product();
            if (isset($request->background_image) && !empty($request->background_image)) {
                $one['image'] = $request->background_image;
                $one['path'] = 'product';
                $one['save_path'] = 'product';
                $image = $this->save($one);
                $create->background_image = $image;
            }

            // $create->cabinet_id = $request->cabinet_id ?? null;
            $create->name = $request->name ?? null;
            // $create->model_number = $request->model_number ?? null;
            // $create->video_link = $request->video_link ?? null;
            // $create->information = $request->information ?? null;
            $create->category = $request->category ?? null;
            $create->color_id = $request->color ?? null;
            $create->colorMaster_id = $request->colorMaster_id ?? null;
            $create->discount_price = $request->discount_price ?? null;
            $create->main_price = $request->main_price ?? null;
            $create->description = $request->description ?? null;
            $create->measurements = $request->measurements ?? null;
            $create->key_features = $request->key_features ?? null;
            $create->return_policies = $request->return_policies ?? null;
            if ($request->category == 1) {

                $create->sort_order = $request->sort_order1;
            } else {

                $create->sort_order = $request->sort_order2;
            }
            $create->status = $request->status ?? null;
            $create->quick_shipping = $request->quick_shipping ?? 2;
            $create->save();


            return redirect()->route('backend.productImage.index', $create->id)->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Product $product
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Product $product
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $product)
    {
        $cabinets = Cabinet::where('status', 1)->get();
        $categories = Type::where('status', 1)->get();
        $colors = ColorMaster::where('status', 1)->get();
        $subColors = Color::where('status', 1)->get();
        // $lengths = Length::where('status', 1)->get();
        // $constructions = ConstructionType::where('status', 1)->get();
        $count1 = Product::where('category', 1)->count();
        $count2 = Product::where('category', '!=', 1)->count();
        return view('backend.master.product.update', compact('count1', 'count2', 'product', 'cabinets', 'categories', 'colors', 'subColors'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Models\Product $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Product $product)
    {

        $request->validate([
            //   'cabinet_id' => 'required',
            //            'name' => 'required',
            // 'model_number' => 'required',
            // 'video_link' => 'required',
            //   'information' => 'required',
            // 'category' => 'required',
            //            'colorMaster_id' => 'required',
            //            'color' => 'required',
            //   'door_style_id' => 'required',
            // 'construction_type' => 'required',
            'description' => 'required',
            'status' => 'required|numeric',
            // 'sort_order' => 'required',
        ]);
        try {
            if (isset($request->background_image) && !empty($request->background_image)) {

                $data['image'] = $request->background_image;
                $data['path'] = 'product';
                $data['save_path'] = 'product';
                $data['old_image']=$product->background_image;
                $image = $this->save($data);
                $product->background_image = $image;
            }
            $colors = ColorMaster::where('id', $request->colorMaster_id)->first();

            $old_slot = $product->sort_order;
            if ($product->category == 1) {
                $new_slot = $request->sort_order1;
            } else {
                $new_slot = $request->sort_order2;
            }


            $updateSlot = Product::where('category', $product->category)->where('sort_order', $new_slot)->first();
            if (!empty($updateSlot)) {
                $updateSlot->sort_order = $old_slot ?? null;
                $updateSlot->save();
            }
            // $product->cabinet_id = $request->cabinet_id ?? null;
            $product->name = $request->name ?? null;
            // $product->model_number = $request->model_number ?? null;
            // $product->video_link = $request->video_link ?? null;
            // $product->information = $request->information ?? null;
            $product->category = $product->category;
            //            $product->color_id = $colors->color_id ?? null;
            //            $product->colorMaster_id = $request->colorMaster_id ?? null;
            // $product->door_style_id = $request->door_style_id ?? null;
            // $product->construction_type = $request->construction_type ?? null;
            $product->description = $request->description ?? null;
            $product->discount_price = $request->discount_price ?? null;
            $product->main_price = $request->main_price ?? null;
            $product->measurements = $request->measurements ?? null;
            $product->key_features = $request->key_features ?? null;
            $product->return_policies = $request->return_policies ?? null;
            $product->sort_order = $new_slot;
            $product->status = $request->status ?? null;
            $product->quick_shipping = $request->quick_shipping ?? 2;
            $product->save();


            return redirect()->route('backend.product.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Product $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        Cart::where('product_id', $product->id)->delete();
        $product->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }

    public function get_colors(Request $request)
    {
        $colorMaster = ColorMaster::where(['id' => $request->master_color_id])->first();
        $product_color_ids = Product::where('colorMaster_id', $colorMaster->id)->pluck('color_id')->toArray();
        $color_id = [];
        if (!empty($product_color_ids)) {
            foreach ($product_color_ids as $product_color_id) {
                $proColors = explode(',', $product_color_id);
                if (!empty($proColors)) {
                    foreach ($proColors as $proColor) {
                        $color_id[] = (int)$proColor;
                    }
                }
            }
        }
        $color_ids = array_unique($color_id);

        $colors = Color::whereIn('id', explode(',', $colorMaster->color_id))
            ->whereNotIn('id', $color_ids)
            ->where('status', 1)
            ->get();

        $html = '';
        if (!empty($colors)) {
            $html .= '<label for="status">Color</label>
                        <select class="form-control select2bs4" name="color">';
            foreach ($colors as $color) {
                $html .= '<option value="' . $color->id . '">' . $color->name . '</option>';
            }
            $html .= '</select>';
        }

        return ['status' => 'success', 'html' => $html];
    }
}
