<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\ProductImage;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ProductImageController extends Controller
{
    use ImageUploadTrait;
    public function index($id, Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = ProductImage::where('product_id', $request->id)
                ->orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    $nestedData['action'] = (string)View::make('backend.master.product.product_action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.product.image', compact('id'));
    }
    public function store(Request $request)
    {
        try {
            // dd($request->file);

            if (isset($request->file) && !empty($request->file)) {
                $img = $request->file;
                // foreach ($request->file as $img) {
                $one['image'] = $img;
                $one['path'] = 'product';
                $one['save_path'] = 'product';
                $image = $this->save($one);
                $pImage = new ProductImage();
                $pImage->product_id = $request->id;
                $pImage->image = $image;

                $pImage->save();
                // }
                return response()->json(['status' => 'success', 'msg' => 'Item(s) updated successfully.']);
            } else {
                return response()->json(['status' => 'error', 'msg' => 'Somthing wrong.']);
            }
            // dd('hlw');

        } catch (Exception $e) {
            return response()->json(['status' => 'error', 'msg' => $e->getMessage()]);
        }
    }
    public function delete($id)
    {
        ProductImage::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
