<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\Type;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class TypeController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Type::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';
                    $nestedData['name'] = $item->name ?? '-';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.galleryType.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.galleryType.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.galleryType.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',

            'name' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'banner';
                $one['save_path'] = 'banner';
                $image = $this->save($one);
            }
            $create = new Type();
            $create->image = $image;
            $create->name = $request->name;
            $create->status = $request->status;
            $create->save();

            return redirect()->route('backend.type.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function show(Type $type)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $type = Type::where('id', $id)->first();
        return view('backend.master.galleryType.update', compact('type'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max size must have 1024.'
        ];
        $request->validate([
            'name' => 'required',
            'status' => 'required|numeric'
        ]);
        try {
            $type = Type::where('id', $id)->first();
            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'banner';
                $data['save_path'] = '/banner';
                $data['old_image']=$type->image;
                $image = $this->save($data);
                $type->image = $image;
            }
            $type->name = $request->name;
            $type->status = $request->status;
            $type->save();

            return redirect()->route('backend.type.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Type  $type
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Type::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
