<?php

namespace App\Http\Controllers\Backend\Master;

use App\Http\Controllers\Controller;
use App\Models\YoutubeLink;
use Exception;
use Illuminate\Http\Request;

class YoutubeLinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $youtubeLink = YoutubeLink::first();
        if (!empty($youtubeLink)) {
            return view('backend.master.youtubeLink.update', compact('youtubeLink'));
        } else {
            return view('backend.master.youtubeLink.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.about.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'youtube_link' => 'required',
        ]);
        try {
            $create = new YoutubeLink();
            $create->youtube_link = $request->youtube_link;
            $create->status =1;
            $create->save();
            return redirect()->route('backend.youtubeLink.edit', $create)->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\YoutubeLink  $youtubeLink
     * @return \Illuminate\Http\Response
     */
    public function show(YoutubeLink $youtubeLink)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\YoutubeLink  $youtubeLink
     * @return \Illuminate\Http\Response
     */
    public function edit(YoutubeLink $youtubeLink)
    {

        return view('backend.master.youtubeLink.update', compact('youtubeLink'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\YoutubeLink  $youtubeLink
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, YoutubeLink $youtubeLink)
    {
        $request->validate([
            'youtube_link' => 'required',
        ]);
        try {

            $youtubeLink->youtube_link = $request->youtube_link;
            $youtubeLink->status = 1;
            $youtubeLink->save();

            return redirect()->back()->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\YoutubeLink  $youtubeLink
     * @return \Illuminate\Http\Response
     */
    public function destroy(YoutubeLink $youtubeLink)
    {
        //
    }
}
