<?php

namespace App\Http\Controllers\Backend;

use Exception;
use Carbon\Carbon;
use App\Models\Order;
use App\Models\Setting;
use App\Models\OrderDetail;
use App\Models\OrderStatus;
use App\Models\PaymentMode;
use App\Models\OrderHistory;
use App\Models\OrderPackage;
use Illuminate\Http\Request;
use App\Models\PaymentStatus;
use App\Http\Controllers\Controller;
use App\Models\OrderProduct;
use Illuminate\Support\Facades\View;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $totalData = Order::count();
            $limit = $request->length;
            $start = $request->start;
            $query = Order::with('user_details')
                ->when($request->query('search_keyword'), function ($query) use ($request) {
                    return $query->where('order_id', 'like', '%' . $request->search_keyword . '%');
                })
                ->when($request->query('start_date') && $request->query('end_date'), function ($query) use ($request) {
                    return $query->whereBetween('created_at', [$request->start_date . " 00:00:00", $request->end_date . " 23:59:59"]);
                })
                ->where('payment_status_id', 2)
                ->orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['order_id'] = $item->order_id;
                    $nestedData['customer_name'] = $item->user_details->name;
                    $nestedData['mobile'] = $item->user_details->mobile ?? '-';
                    $nestedData['price'] = '$ ' . number_format($item->total, 2, ".", "");
                    $nestedData['order_date'] = Carbon::parse($item->created_at)->format('d F Y, h:i A');
                    // $nestedData['order_status'] = '<span class="badge p-1" style="background: ' . $item->orderStatus->color . '">' . $item->orderStatus->title_en . '</span>';

                    $nestedData['order_status'] = 'Sucess';
                    $nestedData['action'] = (string)View::make('backend.order.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => $totalData,
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.order.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        abort(404);
        return view('backend.order.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        abort(404);
        $request->validate([]);
        try {
            return redirect()->route('backend.orders.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Order $order
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $order = Order::with('user_details')->where('id', $id)->first();
        if (!$order) {
            abort(404, 'Invalid Order ID');
        }
        $order_details = OrderProduct::where('order_id', $id)->get();
        return view('backend.order.show', compact('order', 'order_details'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Order $order
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Models\Order $order
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Order $order
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        //
    }

    public function notify(Request $request)
    {
        $notify = false;

        $setting = Setting::find(1);

        $new_order = Order::when($setting->last_order_notify_at, function ($query) use ($setting) {
            return $query->where('created_at', '>=', $setting->last_order_notify_at);
        })->isBooked()->first();

        if ($new_order) {
            $notify = true;
        }

        $setting->last_order_notify_at = Carbon::now();
        $setting->save();

        return response()->json(['status' => true, 'notify' => $notify, 'msg' => 'Success']);
    }

    // public function order_status(Request $request)
    // {
    //     $orderHistory = new OrderHistory();
    //     $orderHistory->order_id = $request->order_id;
    //     $orderHistory->order_status_id = $request->order_status;
    //     $orderHistory->notify = $request->notified;
    //     $orderHistory->comment = $request->comment;
    //     $orderHistory->save();

    //     return redirect()->back()->with('success', 'Status updated successfully.');
    // }
}
