<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\OurServicesRequest;
use App\Models\OurServisesMaster;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class OurServicesRequestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $type = $request->query()['type'] ?? 0;
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $type = $request->query()['type'] ?? 0;
            if ($type == 0) {

                $query = OurServicesRequest::when($request->query('start_date') && $request->query('end_date'), function ($query) use ($request) {
                    return $query->whereBetween('created_at', [$request->start_date . " 00:00:00", $request->end_date . " 23:59:59"]);
                })->orderBy('id', 'desc')->whereNull('servicesMain')->whereNull('servisesmaster_id');
            } else {
                $query = OurServicesRequest::when($request->query('start_date') && $request->query('end_date'), function ($query) use ($request) {
                    return $query->whereBetween('created_at', [$request->start_date . " 00:00:00", $request->end_date . " 23:59:59"]);
                })->orderBy('id', 'desc')->where('servisesmaster_id', $type);
            }
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();
            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {

                    $master = OurServisesMaster::where('id', $item->servisesmaster_id)->first();
                    $nestedData['services'] = $master->name ?? 'Kitchen Cabinet';
                    $nestedData['name'] = $item->name ?? '-';
                    $nestedData['email'] = $item->email ?? '-';
                    $nestedData['phone'] = $item->phone ?? '-';
                    $nestedData['date'] = Carbon::parse($item['created_at'])->format('Y-m-d') ?? '-';
                    // $nestedData['action'] = (string)View::make('backend.ourServicesRequest.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }

        return view('backend.ourServicesRequest.index', compact('type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        OurServicesRequest::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Item(s) deleted successfully.');
    }
}
