<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\PricingTitle;
use Exception;
use Illuminate\Http\Request;

class PricingTitleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pricingTitle = PricingTitle::first();
        if (!empty($pricingTitle)) {
            return view('backend.master.pricingTitle.update', compact('pricingTitle'));
        } else {
            return view('backend.master.pricingTitle.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.pricingTitle.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'title_one' => 'required',
            'title_two' => 'required',
            'description_one' => 'required',
        ]);
        try {
            $create = new PricingTitle();
            $create->title_one = $request->title_one;
            $create->title_two = $request->title_two;
            $create->description_one = $request->description_one;
            $create->save();

            return redirect()->route('backend.pricingTitle.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pricingTitle = PricingTitle::where('id', $id)->first();
        return view('backend.master.pricingTitle.update', compact('pricingTitle'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title_one' => 'required',
            'title_two' => 'required',
            'description_one' => 'required',
        ]);
        try {
            $create = PricingTitle::where('id', $id)->first();
            $create->title_one = $request->title_one;
            $create->title_two = $request->title_two;
            $create->description_one = $request->description_one;
            $create->save();

            return redirect()->route('backend.pricingTitle.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
