<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\ProMember;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ProMemberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = ProMember::when(is_numeric($request->status), function ($query) use ($request) {
                return $query->where('status', $request->status);
            })
                ->when($request->query('search_keyword'), function ($query) use ($request) {
                    return $query->where('name', 'like', '%' . $request->search_keyword . '%')
                        ->orWhere('mobile', 'like', '%' . $request->search_keyword . '%');
                })
                ->when($request->query('start_date') && $request->query('end_date'), function ($query) use ($request) {
                    return $query->whereBetween('created_at', [$request->start_date . " 00:00:00", $request->end_date . " 23:59:59"]);
                })
                ->orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['name'] = $item->name;
                    $nestedData['email'] = $item->email;
                    $nestedData['mobile'] = $item->mobile ?? '-';
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Approved</span>';
                    } elseif ($item->status == 0) {
                        $nestedData['status'] = '<span class="badge badge-warning p-1">Pending</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Rejected</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.proMember.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.proMember.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = ProMember::find($id);
        // dd($user);
        return view('backend.proMember.update', compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $proMember = ProMember::find($id);

        if ($request->is_pro_member == 1) {
            $user_email = User::where('email', $proMember->email)->first();
            if (!empty($user_email)) {
                $user_email->is_pro_member = $request->is_pro_member;
                $user_email->save();
                $proMember->user_id = $user_email->id;
            } else {

                $user = new User();
                $user->name = $proMember->name;
                $user->email = $proMember->email;
                $user->mobile = $proMember->mobile;
                $user->password = $proMember->password;
                $user->type = 2;
                $user->status = 1;
                $user->is_pro_member = $request->is_pro_member;
                $user->save();
                $proMember->user_id = $user->id;
            }
            $proMember->status = 1;
            $proMember->reason = null;
        } else {
            $user_email = User::where('email', $proMember->email)->first();
            if (!empty($user_email)) {
                $user_email->is_pro_member = $request->is_pro_member;
                $user_email->save();
            }
            $proMember->reason = $request->reason;
            $proMember->status = 2;
        }
        $proMember->save();
        return redirect()->route('backend.proMember.index')->with('success', 'Item(s) updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
