<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\QuickShipTitle;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;

class QuickShipTitleController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $quickShipTitle = QuickShipTitle::first();
        if (!empty($quickShipTitle)) {
            return view('backend.master.quickShipTitle.update', compact('quickShipTitle'));
        } else {
            return view('backend.master.quickShipTitle.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.quickShipTitle.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:1024',
            'background_image' => 'required|image|max:1024',
            'title_one' => 'required',
            'title_two' => 'required',
            'title_three' => 'required',
            'title_four' => 'required',
            'title_five' => 'required',
            'title_six' => 'required',
            'description_one' => 'required',
            'description_two' => 'required',
            'button_url_explore_Quick_ship' => 'required',
            'button_url_join_discount_program' => 'required',
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'QuickShipTitle';
                $one['save_path'] = 'QuickShipTitle';
                $image = $this->save($one);
            }
            if (isset($request->background_image) && !empty($request->background_image)) {
                $one['image'] = $request->background_image;
                $one['path'] = 'QuickShipTitle';
                $one['save_path'] = 'QuickShipTitle';
                $background_image = $this->save($one);
            }
            $create = new QuickShipTitle();
            $create->image = $image;
            $create->background_image = $background_image;
            $create->title_one = $request->title_one;
            $create->title_two = $request->title_two;
            $create->title_three = $request->title_three;
            $create->title_four = $request->title_four;
            $create->title_five = $request->title_five;
            $create->title_six = $request->title_six;
            $create->description_one = $request->description_one;
            $create->description_two = $request->description_two;
            $create->button_url_explore_Quick_ship = $request->button_url_explore_Quick_ship;
            $create->button_url_join_discount_program = $request->button_url_join_discount_program;
            $create->save();

            return redirect()->route('backend.quickShipTitle.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $quickShipTitle = QuickShipTitle::where('id', $id)->first();
        return view('backend.master.quickShipTitle.update', compact('quickShipTitle'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max size must have 1024.'
        ];
        $msg = [
            'background_image.max' => 'The background image max size must have 1024.'
        ];

        $request->validate([
            'title_one' => 'required',
            'title_two' => 'required',
            'title_three' => 'required',
            'title_four' => 'required',
            'title_five' => 'required',
            'title_six' => 'required',
            'description_one' => 'required',
            'description_two' => 'required',
            'button_url_explore_Quick_ship' => 'required',
            'button_url_join_discount_program' => 'required',
        ]);
        try {
            $create = QuickShipTitle::where('id', $id)->first();

            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'QuickShipTitle';
                $data['save_path'] = '/QuickShipTitle';
                $data['old_image']=$create->image;
                $image = $this->save($data);
                $create->image = $image;
            }
            if (isset($request->background_image) && !empty($request->background_image)) {
                $request->validate([
                    'background_image' => 'image|max:1024'
                ], $msg);
                $one['image'] = $request->background_image;
                $one['path'] = 'QuickShipTitle';
                $one['save_path'] = 'QuickShipTitle';
                $data['old_image']=$create->background_image;
                $background_image = $this->save($one);
                $create->background_image = $background_image;
            }
            $create->title_one = $request->title_one;
            $create->title_two = $request->title_two;
            $create->title_three = $request->title_three;
            $create->title_four = $request->title_four;
            $create->title_five = $request->title_five;
            $create->title_six = $request->title_six;
            $create->description_one = $request->description_one;
            $create->description_two = $request->description_two;
            $create->button_url_explore_Quick_ship = $request->button_url_explore_Quick_ship;
            $create->button_url_join_discount_program = $request->button_url_join_discount_program;
            $create->save();

            return redirect()->route('backend.quickShipTitle.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
