<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Service;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ServicesController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Service::orderBy('id', 'desc');
            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();

            $data = [];
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['image'] = '<img src="' . asset($item->image) . '" class="type-1">';

                    $nestedData['title'] = (strlen($item->title) > 20) ? substr($item->title, 0, 20) . '...' : $item->title;
                    $nestedData['description'] = (strlen($item->description) > 150) ? substr(strip_tags($item->description), 0, 150) . '...' : strip_tags($item->description);
                    if ($item->status == 1) {
                        $nestedData['status'] = '<span class="badge badge-success p-1">Active</span>';
                    } else {
                        $nestedData['status'] = '<span class="badge badge-danger p-1">Inactive</span>';
                    }
                    $nestedData['action'] = (string)View::make('backend.master.services.action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('backend.master.services.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $services = Service::where('id', $id)->first();
        return view('backend.master.services.update', compact('services'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $msg = [
            'image.max' => 'The image max must size have 1024.'
        ];

        $request->validate([
            'title' => 'required',
            'description' => 'required',
            // 'link' => 'required',
            'status' => 'required|numeric',
        ]);
        try {
            $services = Service::where('id', $id)->first();
            if (isset($request->image) && !empty($request->image)) {
                $request->validate([
                    'image' => 'image|max:1024'
                ], $msg);
                $data['image'] = $request->image;
                $data['path'] = 'blog';
                $data['save_path'] = '/blog';
                $data['old_image']=$services->image;
                $image = $this->save($data);
                $services->image = $image;
            }
            $services->link = $request->link;
            $services->title = $request->title;
            $services->description = $request->description;
            $services->status = $request->status;
            $services->save();

            return redirect()->route('backend.services.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
