<?php

namespace App\Http\Controllers\Backend;

use Exception;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Traits\ImageUploadTrait;
use App\Http\Controllers\Controller;

class SettingsController extends Controller
{
    use ImageUploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function show(Setting $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        return view('backend.settings.update', compact('setting'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Setting $setting)
    {
        $request->validate([
            'site_name' => 'required',
            'copyright' => 'required',
            'facebook' => 'required',
            'google_plus_alpharetta' => 'required',
            'google_plus_norcross' => 'required',
            'google_review_alpharetta' => 'required',
            'google_review_norcross' => 'required',
            'instagram' => 'required',
            'phone_call' => 'required',
            'phone_whatsapp' => 'required',
            'email' => 'required|email',
            'address' => 'required',
            'address1' => 'required',
            'footer_text' => 'required',
            'delivery_charge' => 'required|numeric',
            'map' => 'required',
            'map1' => 'required',
            'descraption' => 'required',


        ]);

        try {
            // Site logo
            if (isset($request->site_logo) && !empty($request->site_logo)) {
                $one['image'] = $request->site_logo;
                $one['path'] = 'setting';
                $one['save_path'] = 'setting';
                $data['old_image']=$setting->site_logo;
                $site_logo = $this->save($one);
                $setting->site_logo = $site_logo;
            }

            // Site fav icon
            if (isset($request->site_fav_icon) && !empty($request->site_fav_icon)) {
                $two['image'] = $request->site_fav_icon;
                $two['path'] = 'setting';
                $two['save_path'] = 'setting';
                $data['old_image']=$setting->site_fav_icon;
                $site_fav_icon = $this->save($two);
                $setting->site_fav_icon = $site_fav_icon;
            }

            $setting->site_name = $request->site_name;
            $setting->copyright = $request->copyright;
            $setting->facebook = $request->facebook;
            $setting->google_plus_alpharetta = $request->google_plus_alpharetta;
            $setting->google_plus_norcross = $request->google_plus_norcross;
            $setting->google_review_alpharetta = $request->google_review_alpharetta;
            $setting->google_review_norcross = $request->google_review_norcross;
            $setting->instagram = $request->instagram;
            $setting->phone_call = $request->phone_call;
            $setting->email = $request->email;
            $setting->address = $request->address;
            $setting->address1 = $request->address1;
            $setting->map = $request->map;
            $setting->map1 = $request->map1;
            $setting->phone_whatsapp = $request->phone_whatsapp;
            $setting->time = $request->time;
            $setting->delivery_charge = $request->delivery_charge;
            $setting->footer_text = $request->footer_text;
            $setting->descraption = $request->descraption;
            $setting->save();

            return redirect()->back()->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function destroy(Setting $setting)
    {
        //
    }
}
