<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\TitleHome;
use Exception;
use Illuminate\Http\Request;

class TitleHomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $title = TitleHome::first();
        if (!empty($title)) {
            return view('backend.master.titleHome.update', compact('title'));
        } else {
            return view('backend.master.titleHome.create');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.master.titleHome.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            // 'title1' => 'required',
            // 'title2' => 'required',
            // 'title3' => 'required',
            // 'title4' => 'required',
            // 'title5' => 'required',
            // 'title6' => 'required',
            'title7' => 'required',
            'title8' => 'required',
            'title9' => 'required',
            'title10' => 'required',
            'title11' => 'required',
            'assembly_title' => 'required',
            'assembly_description' => 'required',

        ]);
        try {
            $title = new TitleHome();
            // $title->title1 = $request->title1;
            // $title->title2 = $request->title2;
            // $title->title3 = $request->title3;
            // $title->title4 = $request->title4;
            // $title->title5 = $request->title5;
            // $title->title6 = $request->title6;
            $title->title7 = $request->title7;
            $title->title8 = $request->title8;
            $title->title9 = $request->title9;
            $title->title10 = $request->title10;
            $title->title11 = $request->title11;
            $title->assembly_title = $request->assembly_title;
            $title->assembly_description = $request->assembly_description;
            $title->save();

            return redirect()->route('backend.titleHome.index')->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $title = TitleHome::where('id', $id)->first();
        return view('backend.master.titleHome.update', compact('title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            // 'title1' => 'required',
            // 'title2' => 'required',
            // 'title3' => 'required',
            // 'title4' => 'required',
            // 'title5' => 'required',
            // 'title6' => 'required',
            'title7' => 'required',
            'title8' => 'required',
            'title9' => 'required',
            'title10' => 'required',
            'title11' => 'required',
            'assembly_title' => 'required',
            'assembly_description' => 'required',

        ]);
        try {
            $title = TitleHome::where('id', $id)->first();
            // $title->title1 = $request->title1;
            // $title->title2 = $request->title2;
            // $title->title3 = $request->title3;
            // $title->title4 = $request->title4;
            // $title->title5 = $request->title5;
            // $title->title6 = $request->title6;
            $title->title7 = $request->title7;
            $title->title8 = $request->title8;
            $title->title9 = $request->title9;
            $title->title10 = $request->title10;
            $title->title11 = $request->title11;
            $title->assembly_title = $request->assembly_title;
            $title->assembly_description = $request->assembly_description;
            $title->save();

            return redirect()->route('backend.titleHome.index')->with('success', 'Item(s) updated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
