<?php

namespace App\Http\Controllers\Cron;

use App\Http\Controllers\Controller;
use App\Models\CustomerReview;
use Exception;
use Illuminate\Http\Request;

class ReviewController extends Controller
{
    // Reviews from google
    public function reviews()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://maps.googleapis.com/maps/api/place/details/json?place_id=ChIJ42a0opd19YgRBk2vv82G104&fields=name%2Crating%2Creviews&reviews_sort=newest&key=AIzaSyDI5ocIEQdXWoyHI47SymcD8E50YMPTM0s',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $results = json_decode($response, true);
        $results = $results['result']['reviews'];

        if (!empty($results)) {
            foreach ($results as $result) {
                if (CustomerReview::where('name', $result['author_name'])->doesntExist()) {
                    // dd($result['text']);
                    try {
                        $create = new CustomerReview();
                        $create->name = $result['author_name'];
                        $create->image = $result['profile_photo_url'];
                        $create->retting = $result['rating'];
                        $create->commend = $result['text'];
                        $create->verified = 2;
                        $create->details = json_encode($result);
                        $create->save();
                    } catch (Exception $e) {
                    }
                }
            }
        }

        return response()->json(['status' => 'success']);
    }
}
