<?php

namespace App\Http\Controllers\Frontend;

use App\Helpers\Carts;
use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\Country;
use App\Models\Coupon;
use App\Models\ProductCombination;
use App\Models\Setting;
use App\Models\State;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CheckoutController extends Controller
{
    public function cart_get()
    {
        $carts = Carts::list();
        $coupons = Coupon::where('status', 1)->get();
        return view('frontend.public.cart', compact('carts', 'coupons'));
    }

    public function cart(Request $request)
    {

        if (Session::has('user_token') && Session::get('user_token')) {
            $token = Session::get('user_token');
        }

        $cart = new Cart();
        if (!empty($request->combi_id)) {

            $combination = ProductCombination::with(['product'])->find($request->combi_id);

            $cart->color_id = $combination->color_id;
            $cart->length_id = $combination->length_id;
        } else {

            $combination = ProductCombination::with(['product'])->find($request->combination);

            $cart->color_id = $combination->product->color_id;
        }

        $cart->token = $token;
        $cart->user_id = auth()->id();
        $cart->product_id = $combination->product_id;
        $cart->product_combination_id = $combination->id;
        $cart->quantity = 1;
        $cart->save();

        if (auth()->check() == false) {
            Session::put('login', 'order');
        }

        $data['cart_count'] = Cart::where(['user_id' => auth()->id()])->count();

        return response()->json(['status' => 'success', 'msg' => 'Add to cart successfully.', 'data' => $data]);
    }

    public function update_cart(Request $request)
    {
        $cart = Cart::find($request->cart_id);
        $cart->quantity = $request->quantity;
        $cart->save();

        return response()->json(['status' => 'success', 'msg' => 'Item(s) quantity updated successfully.']);
    }

    public function remove_cart(Request $request)
    {
        Cart::find($request->cart_id)->delete();


        return response()->json(['status' => 'success', 'msg' => 'Item(s) deleted successfully.']);
    }

    public function remove_cart_all(Request $request)
    {
        Cart::where('token', Session::get('user_token'))->delete();
        $view = view('frontend.public.global.cart')->render();

        return response()->json(['status' => 'success', 'msg' => 'Item(s) deleted successfully.', 'html' => $view]);
    }

    public function checkout()
    {
        if (auth()->check() == false) {
            Session::put('login', 'order');
            return redirect()->route('frontend.login');
        }
        $cart = Cart::with(['product', 'product_combination'])->where('user_id', auth()->id())->get();
        $carts = Carts::list();
        $countries = Country::all();
        $states = State::query();
        if (!empty(\auth()->user()->country)) {
            $states = $states->where('country_id', \auth()->user()->country);
        }
        $states = $states->get();
        return view('frontend.public.checkout', compact('cart', 'carts', 'countries', 'states'));
    }
    public function coupon_apply(Request $request)
    {

        if (auth()->check() == false) {
            return redirect()->back()->with('error', 'Please login');
        }

        $request->validate([
            'coupon' => 'required',
        ]);
        $coupons = Coupon::where('code', $request->coupon)->first();

        // dd($coupons, $request->coupon);
        Session::put('coupon', $coupons);
        return redirect()->back()->with('success', 'Coupon apply successfully.');
    }
}
