<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\ProductCombination;
use App\Models\Tag;
use Illuminate\Http\Request;

class CombinationFilterController extends Controller
{
    public function filter(Request $request)
    {
        $color = $request->color;
        $product_id = $request->product_id;

        $combination = ProductCombination::where([
            // 'color_id' => $color,
            'product_id' => $product_id,
            'in_stock' => 1,
            'status' => 1
        ])->pluck('tag_id')->toArray();
        $combination = Tag::whereIn('id', $combination)->get();
        $com = [];
        if (!empty($combination)) {
            foreach ($combination as $key => $comb) {
                $co['id'] = $comb->id;
                $co['image_url'] = asset($comb->image);
                $co['name'] = $comb->name;
                $com[] = $co;
            }
        }
        //        $combination = ProductCombination::where([
        //            'color_id' => $color,
        //            'product_id' => $product_id,
        //            'in_stock' => 1,
        //            'status' => 1
        //        ])->get();
        $msg = 'Combination found.';
        $success = 'success';
        if (empty($combination)) {
            $msg = 'No combination found.';
            $success = 'error';
        }

        return response()->json(['status' => $success, 'msg' => $msg, 'data' => $com]);
    }

    public function combination_filter(Request $request)
    {
        $color = $request->color;
        $combination = $request->combination;
        $product_id = $request->product_id;
        $combination = ProductCombination::where([
            'tag_id' => $combination,
            //            'color_id' => $color,
            'product_id' => $product_id,
            'in_stock' => 1,
            'status' => 1
        ])->get();
        $com = [];
        if (!empty($combination)) {
            foreach ($combination as $key => $comb) {
                $co['id'] = $comb->id;
                $co['discount_price'] = $comb->discount_price;
                $co['main_price'] = $comb->main_price;
                $co['dimension'] = $comb->dimension;
                $co['image_url'] = asset($comb->image);
                $co['name'] = $comb->name;
                $com[] = $co;
            }
        }
        //        $combination = ProductCombination::where([
        //            'id' => $combination,
        //            'product_id' => $product_id,
        //            'in_stock' => 1,
        //            'status' => 1
        //        ])->get();
        $msg = 'Combination found.';
        $success = 'success';
        if (empty($combination)) {
            $msg = 'No combination found.';
            $success = 'error';
        }

        return response()->json(['status' => $success, 'msg' => $msg, 'data' => $com]);
    }
}
