<?php

namespace App\Http\Controllers\Frontend\Contract;

use App\Http\Controllers\Controller;
use App\Mail\ContactUsMail;
use App\Mail\OtpSendQuoteMail;
use App\Models\ContactFrom;
use App\Models\OurServicesRequest;
use App\Models\UserOtp;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Mail;

class ContactFromController extends Controller
{
    public function contact_submit(Request $request)
    {
        //        $secretKey = config('services.recaptcha.secret_key');
        //        $recaptchaResponse = $request->get('g-recaptcha-response');
        //        $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretKey&response=$recaptchaResponse";
        //        $response = file_get_contents($url);
        //        $responseKeys = json_decode($response, true);
        //
        //        if (!$responseKeys["success"]) {
        //            return redirect()->back()->with('danger', 'reCAPTCHA verification failed!');
        //        }
        $request->validate([
            'name' => 'required|max:50|regex:/^[a-zA-Z\s\'\-]+$/',
            'email' => 'required|email:rfc,dns|max:50|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/',
            'phone' => 'required|digits:10',
            // 'subject' => 'required',
            'messages' => 'required'
        ]);
        try {
            if (UserOtp::where(['email' => $request->email, 'otp' => $request->otp, 'verification_for' => 3, 'verification_type' => 1, 'type' => 2])->orderby('created_at', 'desc')->exists()) {


                $create = new ContactFrom();
                $create->name = $request->name;
                $create->email = $request->email;
                $create->phone = $request->phone;
                // $create->subject = $request->subject;
                $create->messages = $request->messages;
                $create->save();

                try {
                    // $receiver_email = 'sayanatta10@gmail.com';
                    $receiver_email = 'homescabinet@gmail.com';
                    Mail::to($receiver_email)
                        // ->cc(['sayan.swadesh@gmail.com'])
                        ->cc(['seoexperts@software4.net'])
                        ->send(new ContactUsMail($create));
                } catch (Exception $e) {
                    //
                }

                $route = route('frontend.thank.you');
                UserOtp::where(['email' => $request->email, 'otp' => $request->otp, 'verification_for' => 3, 'verification_type' => 1, 'type' => 2])->orderby('created_at', 'desc')->delete();
                return redirect($route)->with('success', "Your details save successfully. We will contact soon.");
            } else {
                return redirect()->back()->with('danger', 'Invalid OTP.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function services_submit(Request $request)
    {
        // if (url()->previous() != route('frontend.kitchenCabinet')) {
        $secretKey = config('services.recaptcha.secret_key');
        $recaptchaResponse = $request->get('g-recaptcha-response');
        $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretKey&response=$recaptchaResponse";
        $response = file_get_contents($url);
        $responseKeys = json_decode($response, true);

        if (!$responseKeys["success"]) {
            return redirect()->back()->with('danger', 'reCAPTCHA verification failed!');
        }
        // }
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',

        ]);
        try {
            $create = new OurServicesRequest();
            if (!empty($request->id)) {
                $create->servisesmaster_id = $request->id ?? 'null';
            } elseif (!empty($request->mainId)) {
                $create->servicesMain = $request->mainId ?? 'null';
            }
            $create->name = $request->name;
            $create->email = $request->email;
            $create->phone = $request->phone;
            $create->save();

            $route = route('frontend.thank.you.services');
            return redirect($route)->with('success', 'Your details save successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function contact_verify(Request $request)
    {
        if (!empty($request->email)) {
            if (App::environment(['local', 'staging'])) {
                $otp = 1111;
            } else {
                $otp = rand(1001, 9998);
            }
            // $this->sendSMS($request->mobile_number, $otp);
            $old = UserOtp::where('type', 2)->where('verification_type', 1)->where('verification_for', 3)->where('email', $request->email)->orderby('created_at', 'desc')->first();
            if (!empty($old)) {

                $start = Carbon::parse($old->created_at);
                $end   = Carbon::now();
                // Difference in minutes 255
                $minutes = $start->diffInMinutes($end);
                if ($minutes <= 5) {
                    return response()->json(['status' => 'success', 'msg' => 'OTP send successfully.']);
                } else {
                    $user_otp = new UserOtp();
                    $user_otp->verification_for = 3;
                    $user_otp->type = 2;
                    $user_otp->email = $request->email;
                    $user_otp->verification_type = 1;
                    $user_otp->otp = $otp;
                    $user_otp->save();
                    $data['email'] = $request->email;
                    $data['otp'] = $user_otp->otp;

                    try {
                        Mail::to($user_otp->email)->send(new OtpSendQuoteMail($data));
                    } catch (Exception $e) {
                    }
                    return response()->json(['status' => 'success', 'msg' => 'OTP send successfully.']);
                }
            } else {
                $user_otp = new UserOtp();
                $user_otp->verification_for = 3;
                $user_otp->type = 2;
                $user_otp->email = $request->email;
                $user_otp->verification_type = 1;
                $user_otp->otp = $otp;
                $user_otp->save();
                $data['email'] = $request->email;
                $data['otp'] = $user_otp->otp;

                try {
                    Mail::to($user_otp->email)->send(new OtpSendQuoteMail($data));
                } catch (Exception $e) {
                }
                return response()->json(['status' => 'success', 'msg' => 'OTP send successfully.']);
            }
        } else {
            return response()->json(['status' => 'error', 'msg' => 'Please enter email.']);
        }
    }
    public function thank_you()
    {
        return view('frontend.public.thankyou');
    }
    public function thank_you_services()
    {
        return view('frontend.public.thank_you_services');
    }
}
