<?php

namespace App\Http\Controllers\Frontend;

use App\Helpers\Carts;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\OrderSendMail;
use App\Models\{Cart, Invoice, Order, OrderProduct, OrderDetail, Setting};
use Exception;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Stripe\{Stripe, Charge};

class OrderController extends Controller
{
    public function order(Request $request)
    {
        if (auth()->check() == false) {
            return redirect()->back();
        }

        $request->validate([
            'email' => 'required|email',
            'name' => 'required',
            'address' => 'required',
            // 'apartment' => 'required',
            'city' => 'required',
            'state' => 'required',
            'country' => 'required',
            'pincode' => 'required',
            'phone_number' => 'required|numeric',
        ]);

        $carts = Cart::with(['product', 'product_combination'])->where('user_id', auth()->id())->get();

        $cart_list = Carts::list();

        $sub_total = $cart_list['subtotal'];
        $total = $cart_list['total_price'];

        $order_count = Order::count();
        $order_count = $order_count + 1;

        $delivery_charge = Setting::first();

        $order = new Order();
        $order->user_id = auth()->id();
        $order->sub_total = $sub_total;
        $order->coupon_discount = 0;
        $order->payment_mode_id = 2;
        $order->payment_status_id = 1;
        if (!empty($delivery_charge) && !empty($delivery_charge['delivery_charge'])) {
            $order->delivery_charge = $delivery_charge['delivery_charge'];
        }
        $order->total = $total;
        $order->save();

        $order_details = new OrderDetail();
        $order_details->order_id = $order->id;
        $order_details->user_id = auth()->id();
        $order_details->name = $request->name;
        $order_details->email = $request->email;
        $order_details->number = $request->phone_number;
        $order_details->address = $request->address;
        $order_details->apartment = $request->apartment;
        $order_details->city = $request->city;
        $order_details->state = $request->state;
        $order_details->country = $request->country;
        $order_details->pincode = $request->pincode;
        $order_details->save();

        if (!empty($carts)) {
            foreach ($carts as $cart) {
                //                $price = $cart->product_combination->main_price - $cart->product_combination->discount_price ?? 0;
                $discount_price = 0;
                if (isset($cart->product_combination->discount_price) && !empty($cart->product_combination->discount_price)) {
                    $price = $cart->product_combination->discount_price;
                    $discount_price = $cart->product_combination->main_price - $cart->product_combination->discount_price;
                } else {
                    $price = $cart->product_combination->main_price;
                }

                $payable_price = $price * $cart->quantity;

                $order_product = new OrderProduct();
                $order_product->order_id = $order->id ?? null;
                $order_product->product_id = $cart->product_id ?? null;
                $order_product->product_combinition_id = $cart->product_combination_id ?? null;
                $order_product->tag_id = $cart->product_combination->tag_id ?? null;
                $order_product->length_id = $cart->product_combination->length_id ?? null;
                $order_product->product_type_id = $cart->product_combination->product_type_id ?? null;
                $order_product->color_id = $cart->color_id ?? null;
                $order_product->tag_name =  $cart->product_combination->tag->name ?? null;
                $order_product->length_name =  $cart->product_combination->length->name ?? null;
                $order_product->product_type_name = $cart->product_combination->productType->name ?? null;
                $order_product->color_name = $cart->color->name ?? null;
                $order_product->image = $cart->product_combination->image ?? null;
                $order_product->name = $cart->product_combination->name ?? null;
                $order_product->dimension = $cart->product_combination->dimension ?? null;
                $order_product->main_price = $cart->product_combination->main_price ?? null;
                $order_product->discount_price = $discount_price ?? null;
                // $order_product->discount_price = $cart->product_combination->discount_price;
                $order_product->quantity = $cart->quantity ?? null;
                $order_product->price = $price ?? null;
                $order_product->payable_price = $payable_price ?? null;
                $order_product->save();
            }
        }
        // Create invoice
        $token = uniqid();
        $payment_token = uniqid();

        $invoice = new Invoice();
        $invoice->invoice_prefix = null;
        $invoice->invoice_no = null;
        $invoice->invoice_id = null;
        $invoice->order_id = $order->id;
        $invoice->transaction_id = null;
        $invoice->transaction_date = null;
        $invoice->currency_code = 'USD';
        $invoice->amount = $order->total;
        $invoice->payment_mode_id = 2;
        $invoice->payment_status = 1; //initialize
        $invoice->token = $token;
        $invoice->payment_token = $payment_token;
        $invoice->created_by = auth()->id();
        $invoice->save();

        // Create Payment
        Stripe::setApiKey(config('services.stripe.api_secret'));

        $charge = Charge::create([
            'amount' => $total * 100, // Amount in cents
            'currency' => 'usd',
            'source' => $request->stripeToken,
            'description' => 'Example payment',
        ]);

        $update_order = Order::find($order->id);
        if ($charge['status'] == 'succeeded') {
            $details = $this->generateOrderId();
            $update_order->payment_status_id = 2;
            $update_order->order_prefix = $details['order_prefix'];
            $update_order->order_no = $details['order_no'];
            $update_order->order_id = $details['order_id'];

            $invoice = Invoice::where('payment_token', $payment_token)->first();
            $invoice->invoice_prefix = 'HB-';
            $invoice->invoice_no = $this->invoice_no();
            $invoice->invoice_id = 'HB-' . $this->invoice_no();
            $invoice->payment_status = 3; //Paid
            $invoice->payment_details = json_encode($charge); //Paid
            $invoice->save();
        } else {
            $update_order->payment_status_id = 2;
        }
        $update_order->save();

        $order = Order::where('id', $order->id)->first();
        $details = OrderDetail::where('order_id', $order->id)->first();
        $data['order_id'] = $order->order_id;
        $data['amount'] = $order->total;

        try {
            Mail::to($details->email)->send(new OrderSendMail($data));
        } catch (Exception $e) {
        }

        Cart::where('token', Session::get('user_token'))->delete();
        return redirect()->route('frontend.order.success', ['order_id' => $order->order_id])->with('success', 'Order placed successfully.');
    }

    public function order_success($order_id)
    {
        if (auth()->check() == false) {
            return redirect()->back();
        }

        return view('frontend.public.order_success', compact('order_id'));
    }

    public function invoice_no()
    {
        $expNum = Invoice::max('invoice_no');

        if (!$expNum) {
            $expNum = 1;
        } else {
            $expNum = (int)$expNum + 1;
        }
        return $expNum;
    }

    public function generateOrderId()
    {
        $order = Order::where('payment_status_id', 2)->orderBy('order_no', 'desc')->first();

        $prefix = 'HC';
        if (!empty($order)) {
            $order_count = $order->order_no + 1;
        } else {
            $order_count = 1;
        }
        $detail['order_prefix'] = 'HC';
        $detail['order_no'] = $order_count;
        $detail['order_id'] = $prefix . '-' . $order_count;

        return $detail;
    }
}
