<?php

namespace App\Http\Controllers\Frontend\Pages;

use Exception;
use App\Models\{Country, State, User, Order, UserOtp, Cart, OrderProduct, ProMember, UserAddess};
use Illuminate\Http\Request;
use App\Traits\ImageUploadTrait;
use App\Http\Controllers\Controller;
use App\Mail\OtpSendMail;
use Carbon\Carbon;
use Illuminate\Support\Facades\{App, Auth, Mail, Session, View};

class AuthFrontendController extends Controller
{
    use ImageUploadTrait;

    public function login()
    {
        return view('frontend.auth.login');
    }

    public function sign_in(Request $request)
    {
        $request->validate([
            'user_email' => 'required|email',
            'user_password' => 'required|min:6',
        ]);
        try {

            if (Auth::attempt(['email' => $request->user_email, 'password' => $request->user_password, 'status' => 1])) {

                if (Session::has('login') && Session::get('login') == 'order') {
                    if (Session::has('user_token') && Session::get('user_token')) {
                        Cart::where('token', Session::get('user_token'))->update(['user_id' => auth()->id()]);
                    }
                    return redirect()->route('frontend.checkout')->with('success', 'User login successfully.');
                    Session::put('login', null);
                } else {
                    return redirect()->route('frontend.index')->with('success', 'User login successfully.');
                }
            } else {
                $data = NULL;
                return redirect()->back()->with('danger', 'Wrong credentials.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    public function signUp()
    {
        $countries = Country::all();
        return view('frontend.auth.signUp', compact('countries'));
    }

    public function sign_up_submit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            // 'l_name' => 'required',
            // 'c_name' => 'required',
            // 'address' => 'required',
            // 'address2' => 'required',
            // 'city' => 'required',
            // 'zipcode' => 'required',
            // 'country' => 'required',
            // 'state' => 'required',
            // 'description' => 'required',
            // 'image' => 'required',
            'password' => 'required',
            'phone' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:6',
        ]);
        try {

            // $one['image'] = $request->image;
            // $one['path'] = 'user';
            // $one['save_path'] = 'user';
            // $image = $this->save($one);
            $user = new User();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->mobile = $request->phone;
            $user->password = $request->password;
            // $user->c_name = $request->c_name;
            // $user->address = $request->address;
            // $user->address2 = $request->address2;
            // $user->city = $request->city;
            // $user->zipcode = $request->zipcode;
            // $user->country = $request->country;
            // $user->state = $request->state;
            // $user->description = $request->description;
            // $user->option1 = $request->option1;
            // $user->option2 = $request->option2;
            // $user->option3 = $request->option3;
            // $user->option4 = $request->option4;
            // $user->avatar = $image;
            $user->type = 2;
            $user->save();

            if (App::environment(['local', 'staging'])) {
                $otp = 1111;
            } else {
                $otp = rand(1001, 9998);
            }
            // $this->sendSMS($request->mobile_number, $otp);
            $user_otp = new UserOtp();
            $user_otp->verification_for = 1;
            $user_otp->user_id = $user->id;
            $user_otp->email = $user->email;
            $user_otp->number = $user->mobile;
            $user_otp->verification_type = 1;
            $user_otp->type = 3;
            $user_otp->verification_type = $request->verification_type;
            $user_otp->otp = $otp;
            $user_otp->save();

            $data['name'] = $request->name;
            $data['email'] = $request->email;
            $data['mobile'] = $request->phone;
            $data['otp'] = $otp;

            try {
                Mail::to($user->email)->send(new OtpSendMail($data));
            } catch (Exception $e) {
            }

            return redirect()->route('frontend.verify', $user->id)->with('success', 'OTP generated successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function proMember()
    {
        $countries = Country::all();
        return view('frontend.auth.becomeProMember', compact('countries'));
    }

    public function proMember_submit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'c_name' => 'required',
            'address' => 'required',
            'address2' => 'required',
            'city' => 'required',
            'zipcode' => 'required',
            'country' => 'required',
            'state' => 'required',
            'description' => 'required',
            'image' => 'required',
            'password' => 'required',
            'phone' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:6',
        ]);
        try {

            $one['image'] = $request->image;
            $one['path'] = 'user';
            $one['save_path'] = 'user';
            $image = $this->save($one);
            $user = new ProMember();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->mobile = $request->phone;
            $user->password = $request->password;
            $user->c_name = $request->c_name;
            $user->address = $request->address;
            $user->address2 = $request->address2;
            $user->city = $request->city;
            $user->zipcode = $request->zipcode;
            $user->country = $request->country;
            $user->state = $request->state;
            $user->description = $request->description;
            $user->option1 = $request->option1;
            $user->option2 = $request->option2;
            $user->option3 = $request->option3;
            $user->option4 = $request->option4;
            $user->avatar = $image;
            $user->created_by = Auth::id();
            $user->status = 0;
            $user->save();



            // try {
            //     Mail::to($user->email)->send(new OtpSendMail($data));
            // } catch (Exception $e) {
            // }

            return redirect()->route('frontend.index')->with('success', 'Thank you for the request.We will update soon.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function verify($user_id)
    {
        $user = User::findOrFail($user_id);
        return view('frontend.auth.verify', compact('user', 'user_id'));
    }

    public function verify_submit(Request $request)
    {
        $user_id = $request->user_id;
        $otp = $request->otp;
        if (UserOtp::where(['user_id' => $user_id, 'otp' => $otp])->exists()) {
            $user = User::findOrFail($user_id);
            $user->status = 1;
            $user->save();

            UserOtp::where(['user_id' => $user_id, 'otp' => $otp])->delete();

            Auth::loginUsingId($user_id);
            if (Session::has('login') && Session::get('login') == 'order') {
                if (Session::has('user_token') && Session::get('user_token')) {
                    Cart::where('token', Session::get('user_token'))->update(['user_id' => auth()->id()]);
                }
                return redirect()->route('frontend.checkout')->with('success', 'User login successfully.');
                Session::put('login', null);
            } else {
                return redirect()->route('frontend.index')->with('success', 'User login successfully.');
            }
        } else {
            return redirect()->back()->with('danger', 'Invalid OTP.');
        }
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect()->route('frontend.index');
    }

    public function user_profile()
    {
        $countries = Country::all();
        $states = State::get();
        // if (!empty(\auth()->user()->country)) {
        //     $states = $states->where('country_id', \auth()->user()->country);
        // }
        // $states = $states->get();
        // dd($states,auth()->user());
        $address = UserAddess::where('user_id', auth()->id())->first();

        return view('frontend.auth.userProfile', compact('countries', 'states', 'address'));
    }

    public function user_profile_submit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'phone' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/',
            'email' => 'required|email',


        ]);
        try {
            $user = User::where('id', Auth::id())->first();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->mobile = $request->phone;
            $user->save();


            return redirect()->back()->with('success', 'Profile update successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function user_address()
    {
        $countries = Country::all();
        $states = State::query();
        if (!empty(\auth()->user()->country)) {
            $states = $states->where('country_id', \auth()->user()->country);
        }
        $states = $states->get();
        $address = UserAddess::where('user_id', auth()->id())->first();
        return view('frontend.auth.userAddress', compact('countries', 'states', 'address'));
    }

    public function user_address_submit(Request $request)
    {

        $request->validate([
            'address' => 'required',
            // 'apartment' => 'required',
            'city' => 'required',
            'state' => 'required',
            'country' => 'required',
            'pincode' => 'required',


        ]);
        try {
            $user = UserAddess::where('user_id', Auth::id())->first();
            if (empty($user)) {
                $user = new UserAddess();
            }
            $user->user_id = auth()->id();
            $user->address = $request->address;
            $user->apartment = $request->apartment;
            $user->city = $request->city;
            $user->state = $request->state;
            $user->country = $request->country;
            $user->pincode = $request->pincode;
            $user->save();


            return redirect()->back()->with('success', 'Profile update successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    public function forget_password()
    {
        return view('frontend.auth.password');
    }

    public function forget_password_submit(Request $request)
    {
        $request->validate([
            'email' => 'required|email',

        ]);
        try {

            $user = User::where('email', $request->email)->first();

            return redirect()->route('frontend.change_password', $user->email)->with('success', 'Successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    public function change_password($user)
    {
        $user = User::where('email', $user)->first();
        return view('frontend.auth.changePassword', compact('user'));
    }

    public function change_password_submit(Request $request)
    {
        $request->validate([
            'password' => 'required|min:6',
            'confirm_password' => 'required_with:password|same:password|min:6',

        ]);
        try {

            $user = User::where('id', Auth::id())->first();
            $user->password = $request->password;
            $user->save();


            return redirect()->back()->with('success', 'Password update successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    public function my_orders(Request $request)
    {
        if ($request->ajax()) {
            $limit = $request->length;
            $start = $request->start;
            $query = Order::with(['user_details', 'order_product'])
                ->where(['user_id' => auth()->id(), 'payment_status_id' => 2])
                ->where('user_id', auth()->id())
                ->orderBy('id', 'desc');
            // with(['user_details', 'order_product'])->->orderBy('id', 'desc')->get();

            $totalFiltered = $query->count();
            $items = $query->offset($start)->limit($limit)->get();
            $data = [];

            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $nestedData['order_id'] = $item->order_id;
                    $nestedData['customer_name'] = $item->user_details->name;
                    $nestedData['mobile'] = $item->user_details->mobile ?? '-';
                    $nestedData['price'] = '$ ' . number_format($item->total, 2, ".", "");
                    $nestedData['order_date'] = Carbon::parse($item->created_at)->format('d F Y, h:i A');
                    $nestedData['order_status'] = 'Sucess';
                    $nestedData['action'] = (string)View::make('frontend.public.order_action', ['item' => $item])->render();
                    $data[$key] = $nestedData;
                }
            }

            $json_data = [
                'draw' => $request->query('draw'),
                'recordsTotal' => count($data),
                'recordsFiltered' => $totalFiltered,
                'data' => $data
            ];
            return response()->json($json_data);
        }
        return view('frontend.public.my_orders');
    }

    public function show($id)
    {
        $order = Order::with(['user_details', 'order_details'])->where('id', $id)->first();
        if (!$order) {
            abort(404, 'Invalid Order ID');
        }
        $order_details = OrderProduct::where('order_id', $id)->get();
        return view('frontend.public.my_order_details', compact('order', 'order_details'));
    }

    public function get_states(Request $request)
    {
        $states = State::where('country_id', $request->country_id)
            ->orderBy('name', 'ASC')
            ->get();

        return response()->json(['status' => 'success', 'message' => 'Success', 'data' => $states]);
    }
}
