<?php

namespace App\Http\Controllers\Frontend\Pages;

use App\Http\Controllers\Controller;
use App\Mail\FreeDesignHelpMail;
use App\Models\About;
use App\Models\AboutAddMor;
use App\Models\AssemblyIsntructions;
use App\Models\Banner;
use App\Models\Blog;
use App\Models\Brand;
use App\Models\Cabinet;
use App\Models\Category;
use App\Models\Cms;
use App\Models\Color;
use App\Models\ColorMaster;
use App\Models\ConstructionType;
use App\Models\CustomerReview;
use App\Models\Door;
use App\Models\Faq;
use App\Models\FreeDesignContent;
use App\Models\FreeDesignRequest;
use App\Models\FreeDesignService;
use App\Models\Gallery;
use App\Models\GeneralAssembly;
use App\Models\GeneralAssemblyVideo;
use App\Models\Guaranteed;
use App\Models\KitchenDesignRequest;
use App\Models\KitchenDesignTool;
use App\Models\Length;
use App\Models\Member;
use App\Models\MetaSeo;
use App\Models\OurServicesMain;
use App\Models\OurServises;
use App\Models\OurServisesMaster;
use App\Models\PricingContent;
use App\Models\PricingTitle;
use App\Models\Product;
use App\Models\ProductCombination;
use App\Models\ProductImage;
use App\Models\ProductType;
use App\Models\QuickShipTitle;
use App\Models\Service;
use App\Models\Setting;
use App\Models\Store;
use App\Models\Tag;
use App\Models\Type;
use App\Models\YoutubeLink;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class PublicController extends Controller
{
    public function index()
    {
        if (!Session::has('user_token') && !Session::get('user_token')) {
            $token = Str::random(60);
            Session::put('user_token', $token);
        }
        $banners = Banner::status()->get();
        $about = About::where('status', 1)->first();
        $assemblyInstruction = AssemblyIsntructions::first();
        $link = YoutubeLink::where('status', 1)->first();
        $YoutubeLink = explode("=", $link->youtube_link);
        $explodeAboutAddMor = explode(',', $about->about_add_mor_id);
        $aboutAddMors = AboutAddMor::where('status', 1)->orderBy('id', 'desc')->get();
        $ourServisesMasters = OurServisesMaster::where('status', 1)->get();
        $blogs = Blog::status()->take(6)->get();
        $customerReviews = CustomerReview::status()->get();
        $customerReviewCount = CustomerReview::count();
        $types = Type::where('status', 1)->pluck('id', 'name')->toArray();
        $view_all = [
            'View all' => 0
        ];
        $types = array_merge($view_all, $types);
        $services = Service::where('status', 1)->orderBy('id', 'asc')->get();
        $categories = Type::where('status', 1)->orderBy('id', 'asc')->get();

        $member = Member::first();
        $guaranteed = Guaranteed::first();
        $stores = Store::where('status', 1)->orderBy('id', 'desc')->get();

        $Galleries = Gallery::where('status', 1)->take(6)->get();
        $seo = MetaSeo::where('page_name', 'home')->first();
        return view('frontend.public.index', compact('seo', 'categories', 'customerReviewCount', 'ourServisesMasters', 'stores', 'guaranteed', 'member', 'services', 'assemblyInstruction', 'YoutubeLink', 'banners', 'about', 'explodeAboutAddMor', 'aboutAddMors', 'blogs', 'customerReviews', 'types', 'Galleries'));
    }

    public function about()
    {
        $about = About::where('status', 1)->first();
        $explodeAboutAddMor = explode(',', $about->about_add_mor_id);
        $aboutAddMors = AboutAddMor::where('status', 1)->orderBy('id', 'desc')->get();
        $customerReviews = CustomerReview::status()->take(10)->get();
        return view('frontend.public.about', compact('about', 'explodeAboutAddMor', 'aboutAddMors', 'customerReviews'));
    }
    public function cabinate_accessories($id)
    {
        $products = Product::where('category', $id)->get();

        $product_id = Product::where('category', $id)->pluck('id')->toArray();
        $color_ids = array_unique(ProductCombination::whereIn('product_id', $product_id)->pluck('color_id')->toArray());
        $colors = Color::whereIn('id', $color_ids)->get();
        return view('frontend.public.cabinate_accessories', compact('products', 'colors'));
    }
    public function cabinate_accessories_details($id)
    {
        $product = Product::where('id', $id)->first();
        $products = Product::where('id', '!=', $id)->where('category', $product->category)->get();
        // $color_ids = array_unique(ProductCombination::where('product_id', $product->id)->pluck('color_id')->toArray());
        $length_ids = array_unique(ProductCombination::where('product_id', $product->id)->pluck('length_id')->toArray());

        $colorsQuery = ProductCombination::with(['color'])->where('product_id', $product->id)->get();
        $tempColorArr = [];
        $colors = [];
        if (!empty($colorsQuery)) {
            foreach ($colorsQuery as $colQue) {
                if (!in_array($colQue->color->name, $tempColorArr)) {
                    $colors[] = $colQue;
                    // dd($colors);
                    $tempColorArr[] = $colQue->color->name;
                }
            }
        }
        $tempColorArr = [];
        // $colors = Color::whereIn('id', $color_ids)->get();
        $lengths = Length::whereIn('id', $length_ids)->get();
        $lengthCount = count($lengths);
        $customerReviews = CustomerReview::status()->take(10)->get();
        $product_image = ProductImage::where('product_id', $id)->first();

        return view('frontend.public.cabinate_accessories_details', compact('product', 'lengthCount', 'customerReviews', 'products', 'colors', 'lengths', 'product_image'));
    }
    public function kitchenCabinet()
    {
        $service = OurServises::where('servisesmaster_id', 0)->first();
        $Galleries = Gallery::where('status', 1)->where('type', 1)->where('type_id', 1)->get();
        $seo = MetaSeo::where('page_name', 'kitchen-cabinet-gallery')->first();
        return view('frontend.public.kitchenCabinetGallery', compact('seo', 'Galleries', 'service'));
    }
    public function gallery($id, $type)
    {
        if ($type == 1) {
            $type = Type::where('id', $id)->first();
            $Galleries = Gallery::where('type_id', $id)->where('status', 1)->get();
        } else {
            $type = OurServisesMaster::where('id', $id)->first();
            $Galleries = Gallery::where('ourservisesmaster_id', $id)->where('status', 1)->get();
        }
        return view('frontend.public.gallery', compact('Galleries', 'type'));
    }
    public function service($id)
    {
        // if ($id != 'kitchen-remodeling-atlanta-georgia') {
        $service_master = OurServisesMaster::where('slug', $id)->first();
        $service = OurServises::where('servisesmaster_id', $service_master->id)->first();
        $YoutubeLink1 = explode("=", $service->youtube_link1);
        $YoutubeLink2 = explode("=", $service->youtube_link2);
        $customerReviews = CustomerReview::status()->take(10)->get();
        $stores = Store::where('status', 1)->orderBy('id', 'desc')->get();
        return view('frontend.public.ourServises', compact('id', 'service', 'YoutubeLink1', 'YoutubeLink2', 'customerReviews', 'stores'));
        // } else {
        //    return redirect()->route('frontend.gallery', ['id' => 2, 'type' => 2]);
        // }
    }
    public function serviceMain()
    {
        $service = OurServicesMain::first();
        $brands = Brand::where('status', 1)->orderBy('sort_order', 'asc')->get();
        $Masters = OurServisesMaster::where('status', 1)->orderBy('id', 'desc')->get();

        return view('frontend.public.services', compact('service', 'brands', 'Masters'));
    }

    public function assembly_isntructions()
    {
        $generalAssemblies = GeneralAssembly::where('status', 1)->get();

        return view('frontend.public.assembly_isntructions', compact('generalAssemblies'));
    }
    public function generalAssemblyVideo($id)
    {
        $generalAssembly = GeneralAssembly::where('id', $id)->first();

        $generalAssemblyVideos = GeneralAssemblyVideo::where('general_assembly_id', $id)->where('status', 1)->get();

        return view('frontend.public.assembly_isntructionsVideo', compact('generalAssemblyVideos', 'generalAssembly'));
    }

    public function blogs()
    {
        $blogs = Blog::status()->paginate(9);
        $relatedblogs = Blog::status()->take(5)->get();
        return view('frontend.public.blog', compact('blogs', 'relatedblogs'));
    }

    public function blog_details($slug)
    {
        $blog = Blog::where('slug', $slug)->first();
        return view('frontend.public.blog_details', compact('blog'));
    }

    public function contact()
    {
        $customerReviews = CustomerReview::status()->take(10)->get();
        $latLong = [
            [
                'lat' => 22.251768,
                'lng' => 88.020830,
            ],
            [
                'lat' => 22.455476,
                'lng' => 88.094559,
            ]
        ];
        return view('frontend.public.contact', compact('customerReviews', 'latLong'));
    }

    public function type($id)
    {
        $productHaveColorMaster = Product::where('category', $id)->pluck('colorMaster_id')->toArray();
        $colorMasters = ColorMaster::where('category_id', $id)
            ->whereIn('id', array_unique($productHaveColorMaster))->get();

        return view('frontend.public.kitchen_cabinets_and_bathroom_vanities', compact('colorMasters', 'id'));
    }
    public function searchType(Request $request)
    {
        $search = $request->query()['query'];
        $query = ColorMaster::where('status', 1);
        if (isset($request->query()['query']) && !empty($request->query()['query'])) {
            $query = $query->where('name', 'like', '%' . $request->query()['query'] . '%');
        }
        $colorMasters = $query->get();

        return view('frontend.public.serchType', compact('colorMasters', 'search'));
    }
    public function product_details(Request $request, $color_id, $color_master_id, $category_id)
    {
        $filter_tag_id = $request->query()['tag'] ?? null;
        $product = Product::where('color_id', $color_id)->where('colorMaster_id', $color_master_id)->where('category', $category_id)->where('status', 1)->first();
        $product_id = $request->query()['product_id'] ?? $product->id;
        $pImages = ProductImage::where('product_id', $product->id)->get();
        $colorMaster = ColorMaster::where('category_id', $category_id)->where('id', $color_master_id)->where('status', 1)->first();
        $getProductColors = Product::where('category', $category_id)
            ->where('status', 1)
            ->pluck('color_id')
            ->toArray();
        $colors = Color::whereIn('id', explode(",", $colorMaster->color_id))
            ->where('id', '!=', $color_id)
            ->whereIn('id', array_unique($getProductColors))
            ->where('status', 1)
            ->get();
        $tag_id = ProductCombination::where('product_id', $product->id)->pluck('tag_id')->toArray();
        $tags = Tag::whereIn('id', array_unique($tag_id))->where('status', 1)->get();
        $product_type_id = ProductCombination::where('product_id', $product->id);
        if (!empty($filter_tag_id)) {
            $product_type_id = $product_type_id->where('tag_id', $filter_tag_id);
        }
        $product_type_id = $product_type_id->pluck('product_type_id')
            ->toArray();
        $productTypes = ProductType::whereIn('id', $product_type_id)->where('status', 1)->get();

        $colorImage = Color::where('id',  $color_id)->get();
        //        dd($pImages);
        $merged = $pImages->merge($colorImage);
        $productImages = [];
        $i = 1;
        if (!empty($colorImage)) {
            foreach ($colorImage as $colorIma) {
                $pro_image['id'] = $i;
                $pro_image['image'] = $colorIma->image;
                $productImages[] = $pro_image;
                $i++;
            }
        }
        if (!empty($pImages)) {
            foreach ($pImages as $pImage) {
                $pro_image['id'] = $i;
                $pro_image['image'] = $pImage->image;
                $productImages[] = $pro_image;
                $i++;
            }
        }
        return view('frontend.public.product_details', compact('product', 'productImages', 'pImages', 'colors', 'tags', 'productTypes', 'filter_tag_id', 'product_id', 'category_id', 'color_id', 'color_master_id'));
    }

    public function refund_policy()
    {
        $refund_policy = Cms::where('key', 1)->first();
        return view('frontend.public.refund_policy', compact('refund_policy'));
    }
    public function design_help()
    {
        $FreeDesignContent = FreeDesignContent::first();
        $FreeDesignServices = FreeDesignService::where('status', 1)->orderBy('id', 'asc')->get();
        $loop = 1;
        return view('frontend.public.design_help', compact('FreeDesignContent', 'FreeDesignServices', 'loop'));
    }
    public function privacy_policy()
    {
        $privacy_policy = Cms::where('key', 2)->first();
        return view('frontend.public.privacy_policy', compact('privacy_policy'));
    }

    public function terms_and_services()
    {
        $terms_and_services = Cms::where('key', 3)->first();
        return view('frontend.public.terms_and_services', compact('terms_and_services'));
    }

    public function return_policy()
    {
        $return_policy = Cms::where('key', 4)->first();
        return view('frontend.public.return_policy', compact('return_policy'));
    }
    public function customerReviews()
    {
        $customerReviews = CustomerReview::status()->paginate(12);
        return view('frontend.public.customerReviews', compact('customerReviews'));
    }
    public function faq()
    {
        $faqs = Faq::where('status', 1)->get();
        return view('frontend.public.faq', compact('faqs'));
    }
    public function kitchen_design()
    {
        $kitchen_design = KitchenDesignTool::first();
        return view('frontend.public.kitchen_design', compact('kitchen_design'));
    }
    public function design_help_submit(Request $request)
    {
        $secretKey = config('services.recaptcha.secret_key');
        $recaptchaResponse = $request->get('g-recaptcha-response');
        $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretKey&response=$recaptchaResponse";
        $response = file_get_contents($url);
        $responseKeys = json_decode($response, true);

        if (!$responseKeys["success"]) {
            return redirect()->back()->with('danger', 'reCAPTCHA verification failed!');
        }
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
        ]);
        try {
            $create = new FreeDesignRequest();
            $create->name = $request->name;
            $create->email = $request->email;
            $create->number = $request->phone;
            $create->save();

            try {
                //                 $receiver_email = 'sayanatta10@gmail.com';
                $receiver_email = 'homescabinet@gmail.com';
                Mail::to($receiver_email)
                    ->cc(['seoexperts@software4.net'])
                    ->send(new FreeDesignHelpMail($create));
            } catch (Exception $e) {
                //
            }
            $route = route('frontend.thank.you.for.design.help');
            return redirect($route)->with('success', 'Item(s) created successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function thank_you_for_design_help()
    {
        return view('frontend.public.thankyou_for_design_help');
    }
    public function kitchen_design_submit(Request $request)
    {
        $request->validate([
            'email' => 'required',

        ]);
        try {
            $create = new KitchenDesignRequest();
            $create->email = $request->email;
            $create->save();

            return redirect()->back()->with('success', 'Email saved successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
    public function quick_ship()
    {
        $quickShipTitle = QuickShipTitle::first();
        $services = Service::where('status', 1)->orderBy('id', 'asc')->get();
        $productHaveColorMaster = Product::where('quick_shipping', 1)
            ->pluck('color_id')
            ->toArray();
        $colors = Color::whereIn('id', array_unique($productHaveColorMaster))
            ->get();
        return view('frontend.public.quick_ship', compact('quickShipTitle', 'services', 'colors'));
    }
    public function pricing()
    {

        $pricingTitle = PricingTitle::first();
        $services = Service::where('status', 1)->orderBy('id', 'asc')->get();
        $contents = PricingContent::where('status', 1)->orderBy('id', 'asc')->get();

        return view('frontend.public.pricing', compact('pricingTitle', 'services', 'contents'));
    }

    public function cabinateAccessoriesCombination(Request $request)
    {
        $data = ProductCombination::where(['product_id' => $request->product_id, 'color_id' => $request->color_id, 'length_id' => $request->length_id])->first();
        if (empty($data)) {
            return response()->json(['status' => 'error', 'msg' => 'Combination not found.', 'data' => NULL]);
        } else {
            return response()->json(['status' => 'success', 'msg' => 'Combination select successfully.', 'data' => $data]);
        }
    }
    public function cabinateAccessoriesFilter(Request $request)
    {
        $color_id = $request->colorFilter ?? null;
        $price = $request->priceFilter ?? null;
        $product_ids = null;
        if (!empty($color_id)) {
            $product_ids = ProductCombination::whereIn('color_id', $color_id)->pluck('product_id')->toArray();
        }
        if (!empty($product_ids) && !empty($price)) {
            $products = Product::where('category', 3)->whereIn('id', $product_ids)->where('status', 1);
            if ($price == 1) {
                $products = $products->orderBy('main_price', 'ASC');
            } else {
                $products = $products->orderBy('main_price', 'DESC');
            }
        } elseif (empty($product_ids) && !empty($price)) {
            $products = Product::where('category', 3)->where('status', 1);
            if ($price == 1) {
                $products = $products->orderBy('main_price', 'ASC');
            } else {
                $products = $products->orderBy('main_price', 'DESC');
            }
        } else {
            $products = Product::whereIn('id', $product_ids)->where('category', 3)->where('status', 1)->orderBy('created_at', 'DESC');
        }
        $products = $products->get();
        $view = view('frontend.public.cabinate_accessories_pro', ['products' => $products])->render();
        return response()->json(['status' => 'success', 'html' => $view]);
    }
}
