<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\PricingRequest;
use App\Traits\ImageUploadTrait;
use Exception;
use Illuminate\Http\Request;

class PricingRequestController extends Controller
{
    use ImageUploadTrait;

    public function pricing_submit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'order_no' => 'required',
            'zip_no' => 'required',
            'customerType' => 'required',
            'image' => 'required',
            'messages' => 'required'
        ]);
        try {
            if (isset($request->image) && !empty($request->image)) {
                $one['image'] = $request->image;
                $one['path'] = 'pricingRequest';
                $one['save_path'] = 'pricingRequest';
                $image = $this->save($one);
            }
            $create = new PricingRequest();
            $create->name = $request->name;
            $create->email = $request->email;
            $create->order_no = $request->order_no;
            $create->zip_no = $request->zip_no;
            $create->image = $image;
            $create->customerType = $request->customerType;
            $create->messages = $request->messages;
            $create->save();

            return redirect()->back()->with('success', 'Your details save successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
}
