<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\QuickShipRequest;
use Exception;
use Illuminate\Http\Request;

class QuickShipRequestController extends Controller
{
    public function quickShip_submit(Request $request)
    {

        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'order_no' => 'required',
            'zip_no' => 'required',
            'messages' => 'required'
        ]);
        try {

            $create = new QuickShipRequest();
            $create->name = $request->name;
            $create->email = $request->email;
            $create->order_no = $request->order_no;
            $create->zip_no = $request->zip_no;
            $create->messages = $request->messages;
            $create->save();

            return redirect()->back()->with('success', 'Your details save successfully.');
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }
}
