<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Mail\GetQuoteMail;
use App\Mail\OtpSendQuoteMail;
use App\Models\Quote;
use App\Models\UserOtp;
use App\Traits\ImageUploadTrait;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Mail;

class QuoteController extends Controller
{
    use ImageUploadTrait;

    public function quote_submit(Request $request)
    {
        // $secretKey = config('services.recaptcha.secret_key');
        // $recaptchaResponse = $request->get('g-recaptcha-response');
        // $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretKey&response=$recaptchaResponse";
        // $response = file_get_contents($url);
        // $responseKeys = json_decode($response, true);

        // if (!$responseKeys["success"]) {
        //     return redirect()->back()->with('danger', 'reCAPTCHA verification failed!');
        // }
        if ($request->filled('website')) {
            abort(403, 'Bot detected');
        }
        if (time() - intval($request->input('loaded_at')) < 3) {
            abort(403, 'Bot detected');
        }
        if ($request->input('human_token') !== 'verified') {
            abort(403, 'Bot detected');
        }
        if ($request->input('js_enabled') !== '1') {
            abort(403, 'Bot detected');
        }
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'messages' => 'required',
            // 'your_space' => 'required',
            // 'project_type' => 'required',
            // 'interested' => 'required',
            // 'budget_range' => 'required',
            // 'project_timeline' => 'required',
            // 'project' => 'required',
            // 'location' => 'required',
        ]);
        try {
            if (UserOtp::where(['email' => $request->email, 'otp' => $request->otp, 'verification_for' => 3, 'verification_type' => 1])->orderby('created_at', 'desc')->exists()) {


                $image = null;
                if (isset($request->image) && !empty($request->image)) {
                    $one['image'] = $request->image;
                    $one['path'] = 'quote';
                    $one['save_path'] = 'quote';
                    $image = $this->save($one);
                }
                $create = new Quote();
                $create->name = $request->name ?? null;
                $create->company_name = $request->company_name ?? null;
                $create->email = $request->email ?? null;
                $create->phone = $request->phone ?? null;
                $create->image = $image;
                $create->your_space = $request->your_space ?? null;
                $create->project_type = $request->project_type ?? null;
                if (!empty($request->project)) {
                    $create->project = implode(",", $request->project);
                }
                /*if (!empty($request->interested)) {
                $create->interested = implode(",", $request->interested);
            }*/
                $create->budget_range = $request->budget_range;
                $create->project_timeline = $request->project_timeline;
                // $create->cabinet = $request->cabinet ?? null;
                // $create->countertop = $request->countertop ?? null;
                // $create->sink = $request->sink ?? null;
                $create->location = $request->location ?? null;
                $create->messages = $request->messages ?? null;
                $create->save();
                try {
                    $receiver_email = 'homescabinet@gmail.com';
                    Mail::to($receiver_email)
                        ->cc(['seoexperts@software4.net'])
                        ->send(new GetQuoteMail($create));
                } catch (Exception $e) {
                    //                dd($e->getMessage());
                }
                UserOtp::where(['email' => $request->email, 'otp' => $request->otp, 'verification_for' => 3, 'verification_type' => 1])->orderby('created_at', 'desc')->delete();
                $route = route('frontend.thank.you.quote');
                return redirect($route)->with('success', 'Your details save successfully.');
            } else {
                return redirect()->back()->with('danger', 'Invalid OTP.');
            }
        } catch (Exception $e) {
            return redirect()->back()->with('danger', $e->getMessage());
        }
    }

    public function quote_verify(Request $request)
    {
        if (!empty($request->email)) {
            if (App::environment(['local', 'staging'])) {
                $otp = 1111;
            } else {
                $otp = rand(1001, 9998);
            }
            // $this->sendSMS($request->mobile_number, $otp);
            $old = UserOtp::where('type', 1)->where('verification_type', 1)->where('verification_for', 3)->where('email', $request->email)->orderby('created_at', 'desc')->first();
            if (!empty($old)) {

                $start = Carbon::parse($old->created_at);
                $end   = Carbon::now();
                // Difference in minutes 255
                $minutes = $start->diffInMinutes($end);
                if ($minutes <= 5) {
                    return response()->json(['status' => 'success', 'msg' => 'OTP send successfully.']);
                } else {
                    $user_otp = new UserOtp();
                    $user_otp->verification_for = 3;
                    $user_otp->email = $request->email;
                    $user_otp->verification_type = 1;
                    $user_otp->type = 1;
                    $user_otp->otp = $otp;
                    $user_otp->save();
                    $data['email'] = $request->email;
                    $data['otp'] = $user_otp->otp;

                    try {
                        Mail::to($user_otp->email)->send(new OtpSendQuoteMail($data));
                    } catch (Exception $e) {
                    }
                    return response()->json(['status' => 'success', 'msg' => 'OTP send successfully.']);
                }
            } else {
                $user_otp = new UserOtp();
                $user_otp->verification_for = 3;
                $user_otp->email = $request->email;
                $user_otp->verification_type = 1;
                $user_otp->type = 1;
                $user_otp->otp = $otp;
                $user_otp->save();
                $data['email'] = $request->email;
                $data['otp'] = $user_otp->otp;

                try {
                    Mail::to($user_otp->email)->send(new OtpSendQuoteMail($data));
                } catch (Exception $e) {
                }
                return response()->json(['status' => 'success', 'msg' => 'OTP send successfully.']);
            }
        } else {
            return response()->json(['status' => 'error', 'msg' => 'Please enter email.']);
        }
    }

    public function thank_you_quote()
    {
        return view('frontend.public.thankyou_quote');
    }
}
