<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    use HasFactory;

    public function product()
    {
        return $this->hasOne(Product::class, 'id', 'product_id');
    }
    public function product_combination()
    {
        return $this->hasOne(ProductCombination::class, 'id', 'product_combination_id')->with(['tag', 'productType']);
    }

    public function color()
    {
        return $this->belongsTo(Color::class, 'color_id');
    }
}
