<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiscountProduct extends Model
{
    use HasFactory;
    public function category()
    {
        return $this->belongsTo(Type::class, 'category')->withTrashed();
    }
    public function productType()
    {
        return $this->belongsTo(ProductType::class, 'product_type_id')->withTrashed();
    }
    // public function master()
    // {
    //     return $this->belongsTo(ColorMaster::class, 'color_master_id')->withTrashed();
    // }
    public function color()
    {
        return $this->belongsTo(Color::class, 'color_id')->withTrashed();
    }
    public function tag()
    {
        return $this->belongsTo(Tag::class, 'tag_id')->withTrashed();
    }
}
