<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Invoice extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'invoices';

    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function paymentMode()
    {
        return $this->belongsTo(PaymentMode::class, 'payment_mode_id');
    }

    public function payment()
    {
        return $this->belongsTo(Payment::class, 'payment_token', 'trackid');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
