<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    public function user_details()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function order_product()
    {
        return $this->belongsTo(OrderProduct::class, 'id', 'order_id');
    }
    public function order_details()
    {
        return $this->belongsTo(OrderDetail::class, 'id', 'order_id');
    }
}
